/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.model.Assignable;
import com.liferay.ide.kaleo.core.model.Role;
import com.liferay.ide.kaleo.core.model.RoleName;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.model.WorkflowNode;
import com.liferay.ide.kaleo.core.op.AssignableOp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.services.Service;

public class RoleNamePossibleValuesMetaService
extends Service {
    private final Map<String, Integer> additionalRoleNames = new HashMap<String, Integer>();
    private static final Set<String> originalRoleNames = new TreeSet<String>();

    static {
        originalRoleNames.add("Organization Administrator");
        originalRoleNames.add("Organization Content Reviewer");
        originalRoleNames.add("Organization Owner");
        originalRoleNames.add("Administrator");
        originalRoleNames.add("Portal Content Reviewer");
        originalRoleNames.add("Site Administrator");
        originalRoleNames.add("Site Content Reviewer");
        originalRoleNames.add("Site Owner");
    }

    protected void initIfNecessary(Object object) {
        block4: {
            block3: {
                if (!(object instanceof WorkflowDefinition)) break block3;
                for (WorkflowNode node : ((WorkflowDefinition)object).getDiagramNodes()) {
                    Assignable assignable = (Assignable)node.nearest(Assignable.class);
                    if (assignable == null) continue;
                    for (Role role : assignable.getRoles()) {
                        String name = (String)role.getName().content(false);
                        if (CoreUtil.isNullOrEmpty((String)name)) continue;
                        originalRoleNames.add(name);
                    }
                }
                break block4;
            }
            if (!(object instanceof AssignableOp)) break block4;
            ElementList<RoleName> roleNames = ((AssignableOp)object).getRoleNames();
            for (RoleName roleName : roleNames) {
                String name = (String)roleName.getName().content(false);
                if (CoreUtil.isNullOrEmpty((String)name)) continue;
                originalRoleNames.add(name);
            }
        }
    }

    protected String[] getRoleNames() {
        TreeSet<String> retval = new TreeSet<String>();
        for (String roleName : this.additionalRoleNames.keySet()) {
            if (this.additionalRoleNames.get(roleName) <= 0) continue;
            retval.add(roleName);
        }
        retval.addAll(originalRoleNames);
        return retval.toArray(new String[0]);
    }

    protected void updateRoleNames(String previousRoleName, String currentRoleName) {
        int times;
        if (previousRoleName != null && currentRoleName != null && previousRoleName.equals(currentRoleName)) {
            return;
        }
        boolean needsBroadcast = false;
        if (!CoreUtil.isNullOrEmpty((String)previousRoleName) && !originalRoleNames.contains(previousRoleName)) {
            int n = times = this.additionalRoleNames.containsKey(previousRoleName) ? this.additionalRoleNames.get(previousRoleName) : 0;
            if (times >= 1) {
                this.additionalRoleNames.put(previousRoleName, new Integer(--times));
            }
            boolean bl = needsBroadcast = times == 0;
        }
        if (!CoreUtil.isNullOrEmpty((String)currentRoleName) && !originalRoleNames.contains(currentRoleName)) {
            times = this.additionalRoleNames.containsKey(currentRoleName) ? this.additionalRoleNames.get(currentRoleName) : 0;
            this.additionalRoleNames.put(currentRoleName, new Integer(++times));
            boolean bl = needsBroadcast ? true : (needsBroadcast = times == 1);
        }
        if (needsBroadcast) {
            this.broadcast();
        }
    }
}

