/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.model.Position;
import com.liferay.ide.kaleo.core.model.TransitionMetadata;
import com.liferay.ide.kaleo.core.model.WorkflowNodeMetadata;
import com.liferay.ide.kaleo.core.model.internal.PositionResource;
import com.liferay.ide.kaleo.core.model.internal.TransitionMetadataObject;
import com.liferay.ide.kaleo.core.model.internal.TransitionMetadataResource;
import com.liferay.ide.kaleo.core.model.internal.WorkflowNodeMetadataObject;
import java.util.List;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.json.JSONException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkflowNodeMetadataResource
extends Resource {
    private WorkflowNodeMetadataObject metadata;

    public WorkflowNodeMetadataResource(WorkflowNodeMetadataObject obj, Resource parent) {
        super(parent);
        this.metadata = obj;
    }

    public WorkflowNodeMetadataObject getMetadata() {
        return this.metadata;
    }

    protected PropertyBinding createBinding(Property property) {
        Object binding = null;
        PropertyDef def = property.definition();
        if (WorkflowNodeMetadata.PROP_TERMINAL.equals(def)) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return Boolean.toString(WorkflowNodeMetadataResource.this.metadata.isTerminal());
                }

                public void write(String value) {
                    WorkflowNodeMetadataResource.this.metadata.setTerminal(Boolean.parseBoolean(value));
                    WorkflowNodeMetadataResource.this.saveMetadata();
                }
            };
        } else if (WorkflowNodeMetadata.PROP_POSITION.equals(def)) {
            binding = new ElementPropertyBinding(){

                public Resource read() {
                    return new PositionResource(WorkflowNodeMetadataResource.this.metadata.getNodeLocation(), WorkflowNodeMetadataResource.this);
                }

                public ElementType type(Resource resource) {
                    return Position.TYPE;
                }
            };
        } else if (WorkflowNodeMetadata.PROP_TRANSITIONS_METADATA.equals(def)) {
            binding = new LayeredListPropertyBinding(){

                public ElementType type(Resource resource) {
                    return TransitionMetadata.TYPE;
                }

                protected List<?> readUnderlyingList() {
                    return WorkflowNodeMetadataResource.this.metadata.getTransitionsMetadata();
                }

                protected Object insertUnderlyingObject(ElementType type, int position) {
                    TransitionMetadataObject newTransitionMeta = new TransitionMetadataObject();
                    WorkflowNodeMetadataResource.this.metadata.getTransitionsMetadata().add(position, newTransitionMeta);
                    WorkflowNodeMetadataResource.this.saveMetadata();
                    return newTransitionMeta;
                }

                public void remove(Resource resource) {
                    TransitionMetadataResource transitionMetaResource = (TransitionMetadataResource)resource;
                    WorkflowNodeMetadataResource.this.metadata.getTransitionsMetadata().remove(transitionMetaResource.getMetadata());
                    WorkflowNodeMetadataResource.this.saveMetadata();
                }

                protected Resource resource(Object obj) {
                    return new TransitionMetadataResource((TransitionMetadataObject)obj, WorkflowNodeMetadataResource.this);
                }
            };
        }
        if (binding != null) {
            binding.init(property);
        }
        return binding;
    }

    public void saveMetadata() {
        XmlElement metadataElement = ((XmlResource)this.parent().adapt(XmlResource.class)).getXmlElement().getChildElement("metadata", true);
        Element domElement = metadataElement.getDomNode();
        try {
            CDATASection cdata = domElement.getOwnerDocument().createCDATASection(this.metadata.toJSONString());
            CoreUtil.removeChildren((Node)domElement);
            domElement.insertBefore(cdata, null);
        }
        catch (JSONException e) {
            KaleoCore.logError((Exception)((Object)e));
        }
    }
}

