/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.viewers;

import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.internal.ui.descriptors.options.LintRule;
import tern.eclipse.ide.internal.ui.descriptors.options.LintRuleSeverity;
import tern.utils.StringUtils;

public class LintRulesLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final LintRulesLabelProvider INSTANCE = new LintRulesLabelProvider();
    private static final int RULE_LABEL = 0;
    private static final int RULE_SEVERITY = 1;

    public static LintRulesLabelProvider getInstance() {
        return INSTANCE;
    }

    public String getColumnText(Object element, int columnIndex) {
        LintRule rule = (LintRule)element;
        switch (columnIndex) {
            case 0: {
                return rule.getLabel();
            }
            case 1: {
                return rule.getSeverity();
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        LintRule rule = (LintRule)element;
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                String id = this.getFieldDecorationId(rule.getSeverity());
                if (!StringUtils.isEmpty((String)id)) {
                    return FieldDecorationRegistry.getDefault().getFieldDecoration(id).getImage();
                }
                return null;
            }
        }
        return null;
    }

    private String getFieldDecorationId(String severity) {
        if (LintRuleSeverity.warning.name().equals(severity)) {
            return "DEC_WARNING";
        }
        if (LintRuleSeverity.error.name().equals(severity)) {
            return "DEC_ERROR";
        }
        return null;
    }
}

