/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.hover;

import java.util.Iterator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.hover.AbstractTernHover;

public class ProblemTernHover
extends AbstractTernHover {
    private static final String ORG_ECLIPSE_WST_SSE_UI_TEMP = "org.eclipse.wst.sse.ui.temp.";
    private DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model;
        IPath path;
        if (textViewer instanceof ISourceViewer) {
            path = null;
            model = ((ISourceViewer)textViewer).getAnnotationModel();
        } else {
            path = this.getEditorInputPath();
            model = this.getAnnotationModel(path);
        }
        if (model == null) {
            return null;
        }
        try {
            Iterator e = model.getAnnotationIterator();
            int layer = -1;
            String message = null;
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                if (!this.isTernAnnotation(a)) continue;
                this.getAnnotationPreference(a);
                Position p = model.getPosition(a);
                int l = this.fAnnotationAccess.getLayer(a);
                if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                message = msg;
                layer = l;
            }
            if (layer > -1) {
                String string = this.formatMessage(message);
                return string;
            }
        }
        finally {
            try {
                if (path != null) {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
            }
            catch (CoreException ex) {
                Trace.trace((byte)3, "Error while get problem info", ex);
            }
        }
        return null;
    }

    protected boolean isTernAnnotation(Annotation a) {
        String type = a.getType();
        return type != null && type.startsWith(ORG_ECLIPSE_WST_SSE_UI_TEMP);
    }

    private String formatMessage(String message) {
        return message;
    }

    private IPath getEditorInputPath() {
        if (this.getEditor() == null) {
            return null;
        }
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException ex) {
                Trace.trace((byte)3, "Error while get editor input path", ex);
            }
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel(IPath path) {
        if (path == null) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, LocationKind.NORMALIZE, null);
        }
        catch (CoreException ex) {
            Trace.trace((byte)3, "Error while get annotation model", ex);
            return null;
        }
        IAnnotationModel model = null;
        try {
            IAnnotationModel iAnnotationModel = model = manager.getTextFileBuffer(path, LocationKind.NORMALIZE).getAnnotationModel();
            return iAnnotationModel;
        }
        finally {
            if (model == null) {
                try {
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
                catch (CoreException ex) {
                    Trace.trace((byte)3, "Error while get annotation model", ex);
                }
            }
        }
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

