/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import tern.eclipse.ide.ui.utils.EditorUtils;
import tern.eclipse.ide.ui.views.AbstractTernContentOutlinePage;
import tern.eclipse.ide.ui.views.ActivateEditorJob;
import tern.eclipse.ide.ui.views.RefreshOutlineJob;
import tern.eclipse.ide.ui.views.UpdateSelectionJob;
import tern.server.protocol.outline.IJSNode;
import tern.server.protocol.outline.TernOutlineCollector;

public abstract class AbstractTernOutlineView
extends ContentOutline {
    public static final int IS_LINKING_ENABLED_PROPERTY = 0;
    private ITextEditor textEditor;
    protected IMemento memento;
    private String LINKING_ENABLED = "AbstractTernOutlineView.LINKING_ENABLED";
    private boolean linkingEnabled = false;
    boolean ignoreEditorActivation;
    boolean ignoreSelectionChanged;
    private ActivateEditorJob activateEditorJob = new ActivateEditorJob(this);
    private final UpdateSelectionJob updateSelectionJob = new UpdateSelectionJob(this);
    private final RefreshOutlineJob refreshJob = new RefreshOutlineJob(this);

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IFile file = this.getFile(part);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        IContentOutlinePage page = this.getOutlinePage(project);
        if (page == null) {
            page = this.createOutlinePage(file.getProject());
            if (page != null) {
                if (page instanceof IPageBookViewPage) {
                    this.initPage((IPageBookViewPage)page);
                }
                page.createControl((Composite)this.getPageBook());
                if (page instanceof AbstractTernContentOutlinePage) {
                    this.updateCurrentFile((IPage)page, part, file);
                }
            }
        } else if (page instanceof AbstractTernContentOutlinePage) {
            this.updateCurrentFile((IPage)page, part, file);
        }
        if (page != null) {
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        IFile file;
        IPage page = pageRec.page;
        IWorkbenchPart part = pageRec.part;
        if (page instanceof AbstractTernContentOutlinePage && (file = this.getFile(part)) != null) {
            this.updateCurrentFile(page, part, file);
        }
        super.showPageRec(pageRec);
    }

    protected IContentOutlinePage getOutlinePage(IProject project) {
        return null;
    }

    protected IFile getFile(IWorkbenchPart part) {
        IFile file;
        if (part != null && part instanceof IEditorPart && (file = EditorUtils.getFile((IEditorPart)part)) != null && this.isAdaptFor(file)) {
            return file;
        }
        return null;
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
        if (this.memento != null) {
            Integer linkingEnabledInteger = this.memento.getInteger(this.LINKING_ENABLED);
            this.setLinkingEnabled(linkingEnabledInteger != null ? linkingEnabledInteger == 1 : false);
        }
    }

    public void saveState(IMemento aMemento) {
        aMemento.putInteger(this.LINKING_ENABLED, this.linkingEnabled ? 1 : 0);
        super.saveState(aMemento);
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean linkingEnabled) {
        this.linkingEnabled = linkingEnabled;
    }

    private void updateCurrentFile(IPage page, IWorkbenchPart part, IFile file) {
        if (this.isEditorChanged(part)) {
            ((AbstractTernContentOutlinePage)page).setCurrentFile(file);
            this.setCurrentPart(part);
        }
    }

    protected boolean isEditorChanged(IWorkbenchPart part) {
        return this.textEditor != part;
    }

    private void setCurrentPart(IWorkbenchPart part) {
        this.textEditor = part instanceof ITextEditor ? (ITextEditor)part : null;
        this.updateSelectionJob.setCurrentPart(part);
    }

    public void openInEditor(IJSNode node, boolean force) {
        this.activateEditorJob.openInEditor(node, force);
    }

    AbstractTernContentOutlinePage getCurrentTernPage() {
        IPage p = this.getCurrentPage();
        if (p == null || !(p instanceof AbstractTernContentOutlinePage)) {
            return null;
        }
        AbstractTernContentOutlinePage page = (AbstractTernContentOutlinePage)p;
        return page;
    }

    CommonViewer getCurrentViewer() {
        AbstractTernContentOutlinePage page = this.getCurrentTernPage();
        return page != null ? page.getViewer() : null;
    }

    public void dispose() {
        super.dispose();
        this.activateEditorJob.cancel();
        this.updateSelectionJob.dispose();
        this.refreshJob.cancel();
    }

    public void refreshOutline() {
        this.refreshJob.refreshOutline();
    }

    protected abstract boolean isAdaptFor(IFile var1);

    protected abstract IContentOutlinePage createOutlinePage(IProject var1);

    public abstract TernOutlineCollector loadOutline(IFile var1, IDocument var2) throws Exception;

    public abstract boolean isOutlineAvailable(IFile var1);
}

