/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class LiferayNature
implements IProjectNature {
    public static final String NATURE_ID = "com.liferay.ide.core.liferayNature";
    private IProject currentProject;
    private IProgressMonitor monitor;

    public LiferayNature() {
        this.monitor = new NullProgressMonitor();
    }

    public LiferayNature(IProject project, IProgressMonitor monitor) {
        this.currentProject = project;
        if (monitor != null) {
            this.monitor = monitor;
        } else {
            monitor = new NullProgressMonitor();
        }
    }

    public static void addLiferayNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!LiferayNature.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = NATURE_ID;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
            project.refreshLocal(2, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void configure() throws CoreException {
        LiferayNature.addLiferayNature(this.currentProject, this.monitor);
        this.currentProject.refreshLocal(2, this.monitor);
    }

    public void deconfigure() throws CoreException {
        LiferayNature.removeLiferayNature(this.currentProject, this.monitor);
        this.currentProject.refreshLocal(2, this.monitor);
    }

    public IProject getProject() {
        return this.currentProject;
    }

    public static boolean hasNature(IProject project) {
        try {
            return project.hasNature(NATURE_ID);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static void removeLiferayNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (LiferayNature.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length - 1];
            int k = 0;
            int i = 0;
            while (i < prevNatures.length) {
                if (!prevNatures[i].equals(NATURE_ID)) {
                    newNatures[k++] = prevNatures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }
}

