/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.handlers;

import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.handlers.AbstractIvyDEHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenIvyFileHandler
extends AbstractIvyDEHandler {
    public static final String COMMAND_ID = "org.apache.ivyde.commands.openivyfile";

    protected void handleContainer(IProject project, IvyClasspathContainerImpl cp) {
        OpenIvyFileHandler.open(cp);
    }

    public static void open(IvyClasspathContainerImpl cp) {
        IvyClasspathContainerConfiguration conf = cp.getConf();
        if (conf.getJavaProject() == null) {
            return;
        }
        IFile file = conf.getJavaProject().getProject().getFile(conf.getIvyXmlPath());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (file != null) {
            try {
                String editorId = "org.apache.ivyde.editors.IvyEditor";
                page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
                IDE.setDefaultEditor((IFile)file, (String)editorId);
            }
            catch (PartInitException e) {
                Shell parent = page.getWorkbenchWindow().getShell();
                String title = "Problems Opening Editor";
                String message = e.getMessage();
                CoreException nestedException = null;
                IStatus status = e.getStatus();
                if (status != null && status.getException() instanceof CoreException) {
                    nestedException = (CoreException)status.getException();
                }
                if (nestedException != null) {
                    ErrorDialog.openError((Shell)parent, (String)title, (String)message, (IStatus)nestedException.getStatus());
                }
                MessageDialog.openError((Shell)parent, (String)title, (String)message);
            }
        }
    }
}

