/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.editors.xml;

import org.apache.ivyde.common.completion.CodeCompletionProposal;
import org.apache.ivyde.common.completion.IvyCodeCompletionProcessor;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModel;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;

public abstract class IvyContentAssistProcessor
implements IContentAssistProcessor {
    private IContextInformationValidator fValidator = new ContextInformationValidator((IContentAssistProcessor)this);
    private String errorMessage = null;
    private IFile file;
    private IvyCodeCompletionProcessor completionProcessor;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String ivyFileString;
        IDocument doc = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        try {
            ivyFileString = doc.get(0, doc.getLength());
        }
        catch (BadLocationException e) {
            IvyPlugin.logError("Getting the content of the document " + doc.toString() + " failed", e);
            return null;
        }
        IProject project = this.getProject();
        IvyFile ivyfile = this.completionProcessor.getModel().newIvyFile(project != null ? project.getName() : "", ivyFileString, documentOffset);
        CodeCompletionProposal[] proposals = this.completionProcessor.computeCompletionProposals(ivyfile, selectedRange.y);
        ICompletionProposal[] ret = new ICompletionProposal[proposals.length];
        int i = 0;
        while (i < proposals.length) {
            CodeCompletionProposal prop = proposals[i];
            ret[i] = new CompletionProposal(prop.getReplacementString(), prop.getReplacementOffset(), prop.getReplacementLength(), prop.getCursorPosition(), null, prop.getDisplayString(), null, prop.getDoc());
            ++i;
        }
        return ret;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', '\"'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public IJavaProject getJavaProject() {
        IProject p = this.getProject();
        return JavaCore.create((IProject)p);
    }

    public IProject getProject() {
        return this.file == null ? null : this.file.getProject();
    }

    public void setFile(IFile file) {
        this.file = file;
        this.completionProcessor = new IvyCodeCompletionProcessor(this.newCompletionModel(file));
    }

    protected abstract IvyModel newCompletionModel(IFile var1);
}

