/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.preferences;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.retrieve.RetrieveSetupManager;
import org.apache.ivyde.internal.eclipse.retrieve.StandaloneRetrieveSetup;
import org.apache.ivyde.internal.eclipse.ui.preferences.EditStandaloneRetrieveDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class IvyDEProjectPreferences
extends PropertyPage
implements IWorkbenchPropertyPage {
    private TableViewer table;
    private RetrieveSetupManager retrieveSetupManager;
    static /* synthetic */ Class class$0;

    public IvyDEProjectPreferences() {
        this.noDefaultAndApplyButton();
        this.retrieveSetupManager = IvyPlugin.getDefault().getRetrieveSetupManager();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(IvyPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        List retrieveSetups;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final IProject project = (IProject)IvyPlugin.adapt(iAdaptable, clazz);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 0));
        label.setText("Retrieve list:");
        this.table = new TableViewer(composite);
        this.table.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.setLabelProvider((IBaseLabelProvider)new RetrieveTableLabelProvider());
        this.table.getTable().setHeaderVisible(true);
        TableColumn col1 = new TableColumn(this.table.getTable(), 0);
        col1.setText("Name");
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(this.table.getTable(), 0);
        col2.setText("Pattern");
        col2.setWidth(200);
        TableColumn col3 = new TableColumn(this.table.getTable(), 0);
        col3.setText("Confs");
        col3.setWidth(50);
        TableColumn col4 = new TableColumn(this.table.getTable(), 0);
        col4.setText("Types");
        col4.setWidth(50);
        this.table.setColumnProperties(new String[]{"Name", "Pattern", "Confs", "Types"});
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)new GridLayout(1, false));
        Button newButton = new Button(buttons, 8);
        newButton.setLayoutData((Object)new GridData(4, 4, false, false));
        newButton.setText("New...");
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandaloneRetrieveSetup setup = new StandaloneRetrieveSetup();
                EditStandaloneRetrieveDialog editDialog = new EditStandaloneRetrieveDialog(IvyDEProjectPreferences.this.getShell(), project, setup);
                if (editDialog.open() == 0) {
                    List list = (List)IvyDEProjectPreferences.this.table.getInput();
                    list.add(editDialog.getStandaloneRetrieveSetup());
                    IvyDEProjectPreferences.this.table.refresh();
                }
            }
        });
        Button editButton = new Button(buttons, 8);
        editButton.setLayoutData((Object)new GridData(4, 4, false, false));
        editButton.setText("Edit...");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvyDEProjectPreferences.this.openEdit((IStructuredSelection)IvyDEProjectPreferences.this.table.getSelection(), project);
            }
        });
        final Button removeButton = new Button(buttons, 8);
        removeButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)IvyDEProjectPreferences.this.table.getInput();
                Iterator it = ((IStructuredSelection)IvyDEProjectPreferences.this.table.getSelection()).iterator();
                while (it.hasNext()) {
                    list.remove(it.next());
                }
                IvyDEProjectPreferences.this.table.refresh();
            }
        });
        removeButton.setEnabled(false);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IvyDEProjectPreferences.this.openEdit((IStructuredSelection)event.getSelection(), project);
            }
        });
        try {
            retrieveSetups = this.retrieveSetupManager.getSetup(project);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.table.setInput((Object)retrieveSetups);
        return composite;
    }

    private void openEdit(IStructuredSelection selection, IProject project) {
        StandaloneRetrieveSetup setup = (StandaloneRetrieveSetup)selection.getFirstElement();
        EditStandaloneRetrieveDialog editDialog = new EditStandaloneRetrieveDialog(this.getShell(), project, setup);
        if (editDialog.open() == 0) {
            List list = (List)this.table.getInput();
            list.set(list.indexOf(setup), editDialog.getStandaloneRetrieveSetup());
            this.table.refresh();
        }
    }

    public boolean performOk() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject project = (IProject)IvyPlugin.adapt(iAdaptable, clazz);
        List retrieveSetups = (List)this.table.getInput();
        try {
            this.retrieveSetupManager.save(project, retrieveSetups);
        }
        catch (Exception e) {
            IvyPlugin.logError("Enable to write the retrieve setup into the project preference of " + project.getName(), e);
            return false;
        }
        return true;
    }

    private class RetrieveTableLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private RetrieveTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            StandaloneRetrieveSetup setup = (StandaloneRetrieveSetup)element;
            switch (columnIndex) {
                case 0: {
                    return setup.getName();
                }
                case 1: {
                    return setup.getRetrieveSetup().getRetrievePattern();
                }
                case 2: {
                    return setup.getRetrieveSetup().getRetrieveConfs();
                }
                case 3: {
                    return setup.getRetrieveSetup().getRetrieveTypes();
                }
            }
            return null;
        }
    }
}

