/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.ILiferayServerBehavior;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import com.liferay.ide.server.ui.util.ServerUIUtil;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class OpenDeployedFolderAction
extends AbstractServerRunningAction {
    private IPath getDeployFolderPath() {
        IPath retval = null;
        if (this.selectedModule != null) {
            this.selectedModule.getModule()[0].getProject();
            ILiferayServerBehavior liferayServerBehavior = (ILiferayServerBehavior)this.selectedModule.getServer().loadAdapter(ILiferayServerBehavior.class, null);
            if (liferayServerBehavior != null) {
                retval = liferayServerBehavior.getDeployedPath(this.selectedModule.getModule());
            }
        }
        return retval;
    }

    @Override
    protected int getRequiredServerState() {
        return 7;
    }

    public void run(IAction action) {
        if (this.selectedModule == null) {
            return;
        }
        IPath folder = this.getDeployFolderPath();
        try {
            String launchCmd = ServerUIUtil.getSystemExplorerCommand(folder.toFile());
            ServerUIUtil.openInSystemExplorer(launchCmd, folder.toFile());
        }
        catch (IOException e) {
            LiferayServerUI.logError("Unable to execute command", e);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.isEnabled()) {
            IPath deployedPath = this.getDeployFolderPath();
            try {
                if (deployedPath == null || !deployedPath.toFile().exists() || CoreUtil.isNullOrEmpty((String)ServerUIUtil.getSystemExplorerCommand(deployedPath.toFile()))) {
                    action.setEnabled(false);
                }
            }
            catch (IOException e) {
                action.setEnabled(false);
            }
        }
    }
}

