/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import com.liferay.ide.server.ui.util.ServerUIUtil;
import com.liferay.ide.server.util.ServerUtil;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.core.IRuntime;

public class OpenLiferayHomeFolderServerAction
extends AbstractServerRunningAction {
    @Override
    protected int getRequiredServerState() {
        return 7;
    }

    public void run(IAction action) {
        if (this.selectedServer != null) {
            IPath path = ServerUtil.getLiferayRuntime((IRuntime)this.selectedServer.getRuntime()).getAppServerDir();
            try {
                ServerUIUtil.openFileInSystemExplorer(path);
            }
            catch (IOException e) {
                LiferayServerUI.logError("Error opening portal home folder.", e);
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.selectedServer != null && selection instanceof IStructuredSelection) {
            IPath path = this.selectedServer.getRuntime().getLocation();
            boolean enabled = false;
            if (path != null) {
                try {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    String launchCmd = ServerUIUtil.getSystemExplorerCommand(path.toFile());
                    if (!CoreUtil.isNullOrEmpty((String)launchCmd) && sel.toList().size() == 1) {
                        enabled = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            action.setEnabled(enabled);
        }
    }
}

