/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.editor;

import com.liferay.ide.server.core.portal.PortalServer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public abstract class AbstractPortalServerEditorSection
extends ServerEditorSection {
    protected boolean allowRestrictedEditing;
    protected PropertyChangeListener listener;
    protected PortalServer portalServer;
    protected IPublishListener publishListener;
    protected Section section;
    protected Hyperlink setDefault;
    protected boolean updating;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (AbstractPortalServerEditorSection.this.updating) {
                    return;
                }
                AbstractPortalServerEditorSection.this.updating = true;
                AbstractPortalServerEditorSection.this.addPropertyListeners(event);
                AbstractPortalServerEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != AbstractPortalServerEditorSection.this.allowRestrictedEditing) {
                    AbstractPortalServerEditorSection.this.allowRestrictedEditing = flag;
                }
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    protected abstract void addPropertyListeners(PropertyChangeEvent var1);

    protected abstract void createEditorSection(FormToolkit var1, Composite var2);

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void createSection(Composite parent) {
        if (!this.needCreate()) {
            return;
        }
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(this.getSectionLabel());
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0002");
        whs.setHelp((Control)this.section, "org.eclipse.wst.server.ui.seop0002");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        this.createEditorSection(toolkit, composite);
        Label label = this.createLabel(toolkit, composite, "");
        GridData data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.setDefault = toolkit.createHyperlink(composite, Msgs.restoreDefaultsLink, 64);
        this.setDefault.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractPortalServerEditorSection.this.updating = true;
                AbstractPortalServerEditorSection.this.setDefault();
                AbstractPortalServerEditorSection.this.updating = false;
                AbstractPortalServerEditorSection.this.validate();
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.setDefault.setLayoutData((Object)data);
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    protected abstract String getSectionLabel();

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (!this.needCreate()) {
            return;
        }
        if (this.server != null) {
            this.portalServer = (PortalServer)this.server.loadAdapter(PortalServer.class, null);
            this.addChangeListeners();
        }
    }

    protected void initialize() {
        if (this.portalServer == null) {
            return;
        }
        this.updating = true;
        this.initProperties();
        this.updating = false;
        this.validate();
    }

    protected abstract void initProperties();

    protected abstract void setDefault();

    protected abstract boolean needCreate();

    protected void validate() {
        if (this.portalServer != null) {
            this.setErrorMessage(null);
        }
    }

    private static class Msgs
    extends NLS {
        public static String restoreDefaultsLink;

        static {
            Msgs.initializeMessages((String)AbstractPortalServerEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

