/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.StringUtil;
import com.liferay.ide.server.core.portal.PortalServerConstants;
import com.liferay.ide.server.ui.cmd.SetDeveloperModeCommand;
import com.liferay.ide.server.ui.cmd.SetExternalPropertiesCommand;
import com.liferay.ide.server.ui.cmd.SetLaunchSettingsCommand;
import com.liferay.ide.server.ui.cmd.SetMemoryArgsCommand;
import com.liferay.ide.server.ui.editor.AbstractPortalServerEditorSection;
import com.liferay.ide.server.util.ServerUtil;
import java.beans.PropertyChangeEvent;
import java.io.File;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortalServerLaunchEditorSection
extends AbstractPortalServerEditorSection {
    protected Button customLaunchSettings;
    protected Button defaultLaunchSettings;
    protected Button developerMode;
    protected Text externalProperties;
    protected Button externalPropertiesBrowse;
    protected Text memoryArgs;

    @Override
    protected void addPropertyListeners(PropertyChangeEvent event) {
        if ("memoryArgs".equals(event.getPropertyName())) {
            this.memoryArgs.setText((String)event.getNewValue());
        } else if ("externalProperties".equals(event.getPropertyName())) {
            this.externalProperties.setText((String)event.getNewValue());
        } else if ("developerMode".equals(event.getPropertyName())) {
            this.developerMode.setSelection(((Boolean)event.getNewValue()).booleanValue());
        } else if ("launchSettings".equals(event.getPropertyName())) {
            boolean s = (Boolean)event.getNewValue();
            this.defaultLaunchSettings.setSelection(s);
            this.customLaunchSettings.setSelection(!s);
        }
    }

    private void applyDefaultPortalServerSetting(boolean useDefaultPortalSeverSetting) {
        if (useDefaultPortalSeverSetting) {
            this.developerMode.setEnabled(false);
            this.externalProperties.setEnabled(false);
            this.externalPropertiesBrowse.setEnabled(false);
            this.memoryArgs.setEnabled(false);
        } else {
            this.developerMode.setEnabled(true);
            this.externalProperties.setEnabled(true);
            this.externalPropertiesBrowse.setEnabled(true);
            this.memoryArgs.setEnabled(true);
        }
    }

    @Override
    protected void createEditorSection(FormToolkit toolkit, Composite composite) {
        GridData data = new GridData(1, 0x1000000, false, false);
        this.defaultLaunchSettings = new Button(composite, 16);
        this.defaultLaunchSettings.setText(Msgs.defaultLaunchSettings);
        data = new GridData(1, 0x1000000, true, false, 3, 1);
        this.defaultLaunchSettings.setLayoutData((Object)data);
        this.defaultLaunchSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetLaunchSettingsCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.defaultLaunchSettings.getSelection()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.applyDefaultPortalServerSetting(PortalServerLaunchEditorSection.this.defaultLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.customLaunchSettings.setSelection(!PortalServerLaunchEditorSection.this.defaultLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        this.customLaunchSettings = new Button(composite, 16);
        this.customLaunchSettings.setText(Msgs.customLaunchSettings);
        data = new GridData(1, 0x1000000, true, false, 3, 1);
        this.customLaunchSettings.setLayoutData((Object)data);
        this.customLaunchSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetLaunchSettingsCommand(PortalServerLaunchEditorSection.this.server, !PortalServerLaunchEditorSection.this.customLaunchSettings.getSelection()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.applyDefaultPortalServerSetting(!PortalServerLaunchEditorSection.this.customLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.defaultLaunchSettings.setSelection(!PortalServerLaunchEditorSection.this.customLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        Label label = this.createLabel(toolkit, composite, Msgs.memoryArgsLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.memoryArgs = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 300;
        this.memoryArgs.setLayoutData((Object)data);
        this.memoryArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetMemoryArgsCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.memoryArgs.getText().trim()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label = this.createLabel(toolkit, composite, Msgs.externalPropertiesLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.externalProperties = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 150;
        this.externalProperties.setLayoutData((Object)data);
        this.externalProperties.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.externalProperties.getText().trim()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        this.externalPropertiesBrowse = toolkit.createButton(composite, Msgs.editorBrowse, 8);
        this.externalPropertiesBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.externalPropertiesBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(PortalServerLaunchEditorSection.this.externalPropertiesBrowse.getShell());
                dialog.setFilterPath(PortalServerLaunchEditorSection.this.externalPropertiesBrowse.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null && !selectedFile.equals(PortalServerLaunchEditorSection.this.externalPropertiesBrowse.getText())) {
                    PortalServerLaunchEditorSection.this.updating = true;
                    PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(PortalServerLaunchEditorSection.this.server, selectedFile));
                    PortalServerLaunchEditorSection.this.externalProperties.setText(selectedFile);
                    PortalServerLaunchEditorSection.this.updating = false;
                    PortalServerLaunchEditorSection.this.validate();
                }
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.developerMode = new Button(composite, 32);
        this.developerMode.setText(Msgs.useDeveloperMode);
        data = new GridData(4, 0x1000000, true, false);
        this.developerMode.setLayoutData((Object)data);
        this.developerMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetDeveloperModeCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.developerMode.getSelection()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
    }

    public IStatus[] getSaveStatus() {
        File externalPropertiesFile;
        String externalPropetiesValue = this.portalServer.getExternalProperties();
        if (!(CoreUtil.isNullOrEmpty((String)externalPropetiesValue) || (externalPropertiesFile = new File(externalPropetiesValue)).exists() && ServerUtil.isValidPropertiesFile((File)externalPropertiesFile))) {
            return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.invalidExternalPropertiesFile)};
        }
        return super.getSaveStatus();
    }

    @Override
    protected String getSectionLabel() {
        return Msgs.liferayLaunch;
    }

    @Override
    protected void initProperties() {
        this.applyDefaultPortalServerSetting(this.portalServer.getLaunchSettings());
        this.customLaunchSettings.setSelection(!this.portalServer.getLaunchSettings());
        this.defaultLaunchSettings.setSelection(this.portalServer.getLaunchSettings());
        this.developerMode.setSelection(this.portalServer.getDeveloperMode());
        this.externalProperties.setText(this.portalServer.getExternalProperties());
        this.memoryArgs.setText(StringUtil.merge((String[])this.portalServer.getMemoryArgs(), (String)" "));
        this.server.setAttribute("auto-publish-time", this.portalServer.getAutoPublishTime());
    }

    @Override
    protected void setDefault() {
        this.execute((IUndoableOperation)new SetMemoryArgsCommand(this.server, PortalServerConstants.DEFAULT_MEMORY_ARGS));
        this.memoryArgs.setText(PortalServerConstants.DEFAULT_MEMORY_ARGS);
        this.execute((IUndoableOperation)new SetExternalPropertiesCommand(this.server, ""));
        this.externalProperties.setText("");
        this.execute((IUndoableOperation)new SetDeveloperModeCommand(this.server, false));
        this.developerMode.setSelection(false);
        this.execute((IUndoableOperation)new SetLaunchSettingsCommand(this.server, true));
        this.defaultLaunchSettings.setSelection(true);
        this.customLaunchSettings.setSelection(false);
        this.applyDefaultPortalServerSetting(true);
    }

    @Override
    protected void validate() {
        if (this.portalServer != null) {
            File externalPropertiesFile;
            String externalPropetiesValue = this.portalServer.getExternalProperties();
            if (!(CoreUtil.isNullOrEmpty((String)externalPropetiesValue) || (externalPropertiesFile = new File(externalPropetiesValue)).exists() && ServerUtil.isValidPropertiesFile((File)externalPropertiesFile))) {
                this.setErrorMessage(Msgs.invalidExternalPropertiesFile);
                return;
            }
            this.setErrorMessage(null);
        }
    }

    @Override
    protected boolean needCreate() {
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String customLaunchSettings;
        public static String defaultLaunchSettings;
        public static String editorBrowse;
        public static String externalPropertiesLabel;
        public static String invalidExternalPropertiesFile;
        public static String liferayLaunch;
        public static String memoryArgsLabel;
        public static String useDeveloperMode;

        static {
            Msgs.initializeMessages((String)PortalServerLaunchEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

