/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.wizard;

import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.wizard.LiferayRuntimeStubComposite;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class LiferayRuntimeStubWizardFragment
extends WizardFragment {
    public static final String LIFERAY_RUNTIME_STUB = "liferay-runtime-stub";
    protected LiferayRuntimeStubComposite composite;

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        wizard.setTitle(Msgs.liferayRuntimeStub);
        wizard.setDescription(Msgs.specifyDirectoryLocation);
        wizard.setImageDescriptor(ImageDescriptor.createFromURL((URL)LiferayServerUI.getDefault().getBundle().getEntry("/icons/wizban/server_wiz.png")));
        this.composite = new LiferayRuntimeStubComposite(parent, wizard);
        return this.composite;
    }

    public void enter() {
        if (this.composite != null) {
            IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.composite.setRuntime(runtime);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate(null);
        return status != null && status.getSeverity() != 4;
    }

    protected ILiferayRuntime getLiferayRuntime() {
        IRuntimeWorkingCopy runtimeWC = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        ILiferayRuntime liferayRuntime = (ILiferayRuntime)runtimeWC.loadAdapter(ILiferayRuntime.class, null);
        return liferayRuntime;
    }

    private static class Msgs
    extends NLS {
        public static String liferayRuntimeStub;
        public static String specifyDirectoryLocation;

        static {
            Msgs.initializeMessages((String)LiferayRuntimeStubWizardFragment.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

