/*
 * Decompiled with CFR 0.152.
 */
package com.ianbrandt.tools.m2e.mdp.core;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.osgi.util.NLS;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MdpBuildParticipant
extends MojoExecutionBuildParticipant {
    private static final String ARTIFACT_ITEMS_PROPERTY = "artifactItems";
    private static final String OUTPUT_DIRECTORY_PROPERTY = "outputDirectory";

    public MdpBuildParticipant(MojoExecution execution) {
        super(execution, true);
    }

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        IMaven maven = MavenPlugin.getMaven();
        MojoExecution mojoExecution = this.getMojoExecution();
        BuildContext buildContext = this.getBuildContext();
        if (mojoExecution == null) {
            return null;
        }
        IFile pomFile = (IFile)this.getMavenProjectFacade().getProject().findMember("pom.xml");
        if (kind != 6 && !buildContext.hasDelta(pomFile.getLocation().toFile())) {
            return null;
        }
        this.setTaskName(monitor);
        Set<IProject> result = this.executeMojo(kind, monitor);
        Set<File> outputDirectories = this.getOutputDirectories(maven, mojoExecution);
        for (File outputDirectory : outputDirectories) {
            this.refreshOutputDirectory(buildContext, outputDirectory);
        }
        return result;
    }

    private Set<File> getOutputDirectories(IMaven maven, MojoExecution mojoExecution) throws CoreException, IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashSet<File> outputDirectories = new HashSet<File>();
        MavenProject mavenProject = this.getMavenProjectFacade().getMavenProject();
        File globalOutputDirectory = (File)maven.getMojoParameterValue(mavenProject, mojoExecution, OUTPUT_DIRECTORY_PROPERTY, File.class, (IProgressMonitor)new NullProgressMonitor());
        List artifactItems = (List)maven.getMojoParameterValue(mavenProject, mojoExecution, ARTIFACT_ITEMS_PROPERTY, List.class, (IProgressMonitor)new NullProgressMonitor());
        Method getOutputDirectoryMethod = null;
        for (Object artifactItem : artifactItems) {
            File artifactItemOutputDirectory;
            if (getOutputDirectoryMethod == null) {
                getOutputDirectoryMethod = new PropertyDescriptor(OUTPUT_DIRECTORY_PROPERTY, artifactItem.getClass()).getReadMethod();
            }
            if ((artifactItemOutputDirectory = (File)getOutputDirectoryMethod.invoke(artifactItem, new Object[0])) != null) {
                outputDirectories.add(artifactItemOutputDirectory);
                continue;
            }
            outputDirectories.add(globalOutputDirectory);
        }
        if (outputDirectories.size() == 0) {
            outputDirectories.add(globalOutputDirectory);
        }
        return outputDirectories;
    }

    private void setTaskName(IProgressMonitor monitor) {
        if (monitor != null) {
            String taskName = NLS.bind((String)"Invoking {0} on {1}", (Object)this.getMojoExecution().getMojoDescriptor().getFullGoalName(), (Object)this.getMavenProjectFacade().getProject().getName());
            monitor.setTaskName(taskName);
        }
    }

    private Set<IProject> executeMojo(int kind, IProgressMonitor monitor) throws Exception {
        return super.build(kind, monitor);
    }

    private void refreshOutputDirectory(BuildContext buildContext, File outputDirectory) {
        if (outputDirectory != null && outputDirectory.exists()) {
            buildContext.refresh(outputDirectory);
        }
    }
}

