/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.AbstractLiferayProjectImporter;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class GradleModuleProjectImporter
extends AbstractLiferayProjectImporter {
    private IProject refreshProject = null;

    public IStatus canImport(String location) {
        Status retval = null;
        File file = new File(location);
        if (this.findGradleFile(file)) {
            if (this.findSettingsFile(file)) {
                return Status.OK_STATUS;
            }
            File parent = file.getParentFile();
            while (parent != null) {
                if (this.findGradleFile(parent)) {
                    File gradleFile = new File(file, "build.gradle");
                    IPath gradleFilelocation = Path.fromOSString((String)gradleFile.getAbsolutePath());
                    IFile ifile = CoreUtil.getWorkspaceRoot().getFileForLocation(gradleFilelocation);
                    if (ifile != null && ifile.getProject() != null) {
                        this.refreshProject = ifile.getProject();
                        retval = new Status(2, "com.liferay.ide.gradle.core", "Project is inside \"" + this.refreshProject.getName() + "\" project. we will just refresh to import");
                    } else {
                        retval = new Status(4, "com.liferay.ide.gradle.core", "Location is not the root location of a multi-module project.");
                    }
                    return retval;
                }
                parent = parent.getParentFile();
            }
            if (retval == null) {
                return Status.OK_STATUS;
            }
        }
        return retval;
    }

    private boolean findFile(File dir, String name) {
        boolean retval = false;
        if (dir.exists()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory() && file.getName().equals(name)) {
                    retval = true;
                }
                ++n2;
            }
        }
        return retval;
    }

    private boolean findGradleFile(File dir) {
        return this.findFile(dir, "build.gradle");
    }

    private boolean findSettingsFile(File dir) {
        return this.findFile(dir, "settings.gradle");
    }

    public List<IProject> importProjects(String location, IProgressMonitor monitor) throws CoreException {
        if (this.refreshProject != null) {
            GradleUtil.refreshGradleProject(this.refreshProject);
            this.refreshProject = null;
        } else {
            GradleUtil.importGradleProject(new File(location), monitor);
        }
        return new ArrayList<IProject>();
    }
}

