/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.gradle.core.parser.GradleDependency;
import com.liferay.ide.gradle.core.parser.GradleDependencyUpdater;
import com.liferay.ide.project.core.AbstractProjectBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GradleProjectBuilder
extends AbstractProjectBuilder {
    private IFile gradleBuildFile;

    public GradleProjectBuilder(IProject project) {
        super(project);
        this.gradleBuildFile = project.getFile("build.gradle");
    }

    public IStatus buildLang(IFile langFile, IProgressMonitor monitor) throws CoreException {
        return this.runGradleTask("buildLang", monitor);
    }

    public IStatus buildService(IProgressMonitor monitor) throws CoreException {
        return this.runGradleTask("buildService", monitor);
    }

    public IStatus buildWSDD(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    private IStatus runGradleTask(String task, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (this.gradleBuildFile.exists()) {
            try {
                monitor.beginTask(task, 100);
                GradleUtil.runGradleTask(this.getProject(), task, monitor);
                monitor.worked(80);
                this.getProject().refreshLocal(2, monitor);
                monitor.worked(10);
            }
            catch (Exception e) {
                status = GradleCore.createErrorStatus("Error running Gradle goal " + task, e);
            }
        } else {
            status = GradleCore.createErrorStatus("No build.gradle file");
        }
        return status;
    }

    public IStatus execInitBundle(IProject project, String taskName, String bundleUrl, IProgressMonitor monitor) throws CoreException {
        String bundleUrlProperty = "\n\nliferay.workspace.bundle.url=" + bundleUrl;
        File gradlePropertiesFile = project.getFile("gradle.properties").getLocation().toFile();
        try {
            Files.write(gradlePropertiesFile.toPath(), bundleUrlProperty.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            GradleCore.logError("Error append bundle url property", e);
        }
        this.runGradleTask(taskName, monitor);
        project.refreshLocal(2, monitor);
        return Status.OK_STATUS;
    }

    public IStatus updateProjectDependency(IProject project, List<String[]> dependencies) throws CoreException {
        try {
            if (this.gradleBuildFile.exists()) {
                GradleDependencyUpdater updater = new GradleDependencyUpdater(this.gradleBuildFile.getLocation().toFile());
                List<GradleDependency> existDependencies = updater.getAllDependencies();
                for (String[] dependency : dependencies) {
                    GradleDependency gd = new GradleDependency(dependency[0], dependency[1], dependency[2]);
                    if (existDependencies.contains(gd)) continue;
                    updater.insertDependency(gd);
                    FileUtils.writeLines((File)this.gradleBuildFile.getLocation().toFile(), updater.getGradleFileContents());
                    HashSet<IProject> set = new HashSet<IProject>();
                    set.add(project);
                    CorePlugin.gradleWorkspaceManager().getCompositeBuild(set).synchronize(NewProjectHandler.IMPORT_AND_MERGE);
                }
            }
        }
        catch (IOException e) {
            return GradleCore.createErrorStatus("Error updating gradle project dependency", e);
        }
        return Status.OK_STATUS;
    }
}

