/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import aQute.bnd.osgi.Jar;
import com.liferay.blade.gradle.model.CustomModel;
import com.liferay.ide.core.BaseLiferayProject;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.IResourceBundleProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.gradle.core.BlockingResultHandler;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleProjectBuilder;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;

public class LiferayGradleProject
extends BaseLiferayProject
implements IBundleProject,
IResourceBundleProject {
    private static final String[] ignorePaths = new String[]{".gradle", "build", "dist", "liferay-theme.json"};

    public <T> T adapt(Class<T> adapterType) {
        Object adapter = super.adapt(adapterType);
        if (adapter != null) {
            return (T)adapter;
        }
        if (IProjectBuilder.class.equals(adapterType)) {
            GradleProjectBuilder projectBuilder = new GradleProjectBuilder(this.getProject());
            return adapterType.cast((Object)projectBuilder);
        }
        return null;
    }

    public static IPath getOutputBundlePath(IProject gradleProject) {
        IPath retval = null;
        CustomModel model = GradleCore.getToolingModel(GradleCore.getDefault(), CustomModel.class, gradleProject);
        Set outputFiles = model.getOutputFiles();
        if (outputFiles.size() > 0) {
            File bundleFile = null;
            for (File outputFile : outputFiles) {
                if (!outputFile.getName().endsWith(".war")) continue;
                bundleFile = outputFile;
                break;
            }
            if (bundleFile == null) {
                for (File outputFile : outputFiles) {
                    String name = outputFile.getName();
                    if (name.endsWith("javadoc.jar") || name.endsWith("jspc.jar") || name.endsWith("sources.jar") || !name.endsWith(".jar")) continue;
                    bundleFile = outputFile;
                    break;
                }
            }
            if (bundleFile != null) {
                retval = new Path(bundleFile.getAbsolutePath());
            }
        } else if (model.hasPlugin("com.liferay.gradle.plugins.gulp.GulpPlugin")) {
            retval = gradleProject.getLocation().append("dist/" + gradleProject.getName() + ".war");
        }
        return retval;
    }

    public LiferayGradleProject(IProject project) {
        super(project);
    }

    public boolean filterResource(IPath resourcePath) {
        return this.filterResource(resourcePath, ignorePaths);
    }

    public String getBundleShape() {
        return "jar";
    }

    public List<IFile> getDefaultLanguageProperties() {
        return PropertiesUtil.getDefaultLanguagePropertiesFromModuleProject((IProject)this.getProject());
    }

    public IFolder getSourceFolder(String classification) {
        IFolder[] sourceFolders;
        IFolder retval = null;
        IFolder[] iFolderArray = sourceFolders = this.getSourceFolders();
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            if (folder.getName().equals(classification)) {
                retval = folder;
                break;
            }
            ++n2;
        }
        if (classification.equals("resources") && retval == null) {
            retval = this.createResorcesFolder(this.getProject());
        }
        return retval;
    }

    public IFolder[] getSourceFolders() {
        IFile gulpFile = this.getProject().getFile("gulpfile.js");
        if (gulpFile != null && gulpFile.exists()) {
            return new IFolder[]{this.getProject().getFolder("src")};
        }
        return super.getSourceFolders();
    }

    private IFolder createResorcesFolder(IProject project) {
        try {
            IFolder[] sourceFolders;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            List<IClasspathEntry> existingRawClasspath = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newRawClasspath = new ArrayList<IClasspathEntry>();
            IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"FROM_GRADLE_MODEL", (String)"true")};
            IClasspathEntry resourcesEntry = JavaCore.newSourceEntry((IPath)project.getFullPath().append("src/main/resources"), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IClasspathAttribute[])attributes);
            for (IClasspathEntry entry : existingRawClasspath) {
                newRawClasspath.add(entry);
            }
            if (!existingRawClasspath.contains(resourcesEntry)) {
                newRawClasspath.add(resourcesEntry);
            }
            javaProject.setRawClasspath(newRawClasspath.toArray(new IClasspathEntry[0]), (IProgressMonitor)new NullProgressMonitor());
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            IFolder[] iFolderArray = sourceFolders = this.getSourceFolders();
            int n = sourceFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder = iFolderArray[n2];
                if (folder.getName().equals("resources")) {
                    return folder;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            GradleCore.logError((Exception)((Object)e));
        }
        return null;
    }

    public IFile getDescriptorFile(String name) {
        return this.getProject().getFile(name);
    }

    public IPath getLibraryPath(String filename) {
        return null;
    }

    public IPath getOutputBundle(boolean cleanBuild, IProgressMonitor monitor) throws CoreException {
        IPath outputBundlePath = LiferayGradleProject.getOutputBundlePath(this.getProject());
        try (ProjectConnection connection = null;){
            try {
                GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(this.getProject().getLocation().toFile());
                connection = connector.connect();
                BuildLauncher launcher = connection.newBuild();
                BlockingResultHandler<Object> handler = new BlockingResultHandler<Object>(Object.class);
                if (cleanBuild) {
                    launcher.forTasks(new String[]{"clean", "assemble"}).run(handler);
                } else {
                    launcher.forTasks(new String[]{"assemble"}).run(handler);
                }
                handler.getResult();
            }
            catch (GradleConnectionException e) {
                GradleCore.logError("Unable to build output", (Exception)((Object)e));
                connection.close();
                return null;
            }
        }
        outputBundlePath = LiferayGradleProject.getOutputBundlePath(this.getProject());
        if (outputBundlePath.toFile().exists()) {
            return outputBundlePath;
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        return null;
    }

    public String getSymbolicName() throws CoreException {
        String bsn = ProjectUtil.getBundleSymbolicNameFromBND((IProject)this.getProject());
        if (!CoreUtil.empty((String)bsn)) {
            return bsn;
        }
        String retval = null;
        IPath outputBundle = LiferayGradleProject.getOutputBundlePath(this.getProject());
        if (outputBundle == null || outputBundle.lastSegment().endsWith(".war")) {
            return this.getProject().getName();
        }
        if (outputBundle != null && outputBundle.toFile().exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Jar jar = new Jar(outputBundle.toFile());){
                    retval = jar.getBsn();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public boolean isFragmentBundle() {
        IFile bndFile = this.getProject().getFile("bnd.bnd");
        if (bndFile.exists()) {
            try {
                String content = FileUtil.readContents((InputStream)bndFile.getContents());
                if (content.contains("Fragment-Host")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

