/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.BaseLiferayProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.IMavenProject;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenProjectRemoteServerPublisher;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.remote.IRemoteServerPublisher;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;

public abstract class LiferayMavenProject
extends BaseLiferayProject
implements IMavenProject {
    public LiferayMavenProject(IProject project) {
        super(project);
    }

    public <T> T adapt(Class<T> adapterType) {
        Object adapter = super.adapt(adapterType);
        if (adapter != null) {
            return (T)adapter;
        }
        IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)new NullProgressMonitor());
        if (facade != null) {
            if (IProjectBuilder.class.equals(adapterType)) {
                MavenProjectBuilder projectBuilder = new MavenProjectBuilder(this.getProject());
                return adapterType.cast((Object)projectBuilder);
            }
            if (IRemoteServerPublisher.class.equals(adapterType)) {
                MavenProjectRemoteServerPublisher remoteServerPublisher = new MavenProjectRemoteServerPublisher(this.getProject());
                return adapterType.cast((Object)remoteServerPublisher);
            }
        }
        return null;
    }

    public IPath getLibraryPath(String filename) {
        Object[] libs = this.getUserLibs();
        if (!CoreUtil.isNullOrEmpty((Object[])libs)) {
            Object[] objectArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                Object lib = objectArray[n2];
                if (lib.removeFileExtension().lastSegment().startsWith(filename)) {
                    return lib;
                }
                ++n2;
            }
        }
        return null;
    }

    public String getLiferayMavenPluginVersion() {
        String retval = null;
        IMavenProjectFacade projectFacade = MavenPlugin.getMavenProjectRegistry().getProject(this.getProject());
        if (projectFacade != null) {
            try {
                NullProgressMonitor npm = new NullProgressMonitor();
                MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)npm);
                if (mavenProject != null) {
                    Plugin liferayMavenPlugin = MavenUtil.getPlugin(projectFacade, "com.liferay.maven.plugins:liferay-maven-plugin", (IProgressMonitor)npm);
                    retval = liferayMavenPlugin.getVersion();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return retval;
    }

    public String getProperty(String key, String defaultValue) {
        IMavenProjectFacade projectFacade;
        String retval = defaultValue;
        if (("theme.type".equals(key) || "theme.parent".equals(key)) && ProjectUtil.isThemeProject((IProject)this.getProject()) && (projectFacade = MavenUtil.getProjectFacade(this.getProject())) != null) {
            MavenProject mavenProject = projectFacade.getMavenProject();
            retval = "theme.type".equals(key) ? MavenUtil.getLiferayMavenPluginConfig(mavenProject, "themeType") : MavenUtil.getLiferayMavenPluginConfig(mavenProject, "parentTheme");
        }
        return retval;
    }

    public IFolder getSourceFolder(String classification) {
        IFolder retval = super.getSourceFolder(classification);
        List sourceFolders = CoreUtil.getSourceFolders((IJavaProject)JavaCore.create((IProject)this.getProject()));
        for (IFolder folder : sourceFolders) {
            if (!folder.getName().equals(classification)) continue;
            retval = folder;
            break;
        }
        return retval;
    }

    @Override
    public IPath[] getUserLibs() {
        ArrayList<IPath> libs = new ArrayList<IPath>();
        IClasspathManager buildPathManager = MavenJdtPlugin.getDefault().getBuildpathManager();
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = buildPathManager.getClasspath(this.getProject(), 1, true, (IProgressMonitor)new NullProgressMonitor());
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                libs.add(entry.getPath());
                ++n2;
            }
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get maven classpath.", e);
        }
        return libs.toArray(new IPath[0]);
    }
}

