/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.dd.HookDescriptorHelper;
import com.liferay.ide.hook.core.util.HookUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenExtPluginFacetInstallProvider;
import com.liferay.ide.maven.core.MavenHookPluginFacetInstallProvider;
import com.liferay.ide.maven.core.MavenLayoutTplPluginFacetInstallProvider;
import com.liferay.ide.maven.core.MavenPortletPluginFacetInstallProvider;
import com.liferay.ide.maven.core.MavenThemePluginFacetInstallProvider;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.MavenWebPluginFacetInstallProvider;
import com.liferay.ide.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Version;

public class LiferayMavenProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final IPath ROOT_PATH = new Path("/");
    private static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-war-plugin";
    private static final String WAR_SOURCE_FOLDER = "/src/main/webapp";
    private IMavenMarkerManager mavenMarkerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();

    private MavenProblemInfo checkValidConfigDir(Plugin liferayMavenPlugin, Xpp3Dom config, String configParam) {
        MavenProblemInfo retval = null;
        String message = null;
        String value = null;
        if (configParam != null) {
            if (config == null) {
                message = NLS.bind((String)Msgs.missingConfigValue, (Object)configParam);
            } else {
                Xpp3Dom dirNode = config.getChild(configParam);
                if (dirNode == null) {
                    message = NLS.bind((String)Msgs.missingConfigValue, (Object)configParam);
                } else {
                    value = dirNode.getValue();
                    if (CoreUtil.isNullOrEmpty((String)value)) {
                        message = NLS.bind((String)Msgs.emptyConfigValue, (Object)configParam);
                    } else {
                        File configDir = new File(value);
                        if (!configDir.exists() || !configDir.isDirectory()) {
                            message = NLS.bind((String)Msgs.unusableConfigValue, (Object)configParam, (Object)value);
                        }
                    }
                }
            }
        }
        if (message != null) {
            SourceLocation location = SourceLocationHelper.findLocation((Plugin)liferayMavenPlugin, (String)"configuration");
            retval = new MavenProblemInfo(message, 1, location);
        }
        return retval;
    }

    private MavenProblemInfo checkValidVersion(Plugin plugin, Xpp3Dom config, String versionNodeName) {
        Xpp3Dom versionNode;
        MavenProblemInfo retval = null;
        Version liferayVersion = null;
        String version = null;
        if (config != null && (versionNode = config.getChild(versionNodeName)) != null) {
            version = versionNode.getValue();
            try {
                liferayVersion = new Version(MavenUtil.getVersion(version));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (liferayVersion == null || liferayVersion.equals((Object)ILiferayConstants.EMPTY_VERSION)) {
            SourceLocation location = SourceLocationHelper.findLocation((Plugin)plugin, (String)"configuration");
            String problemMsg = NLS.bind((String)Msgs.unusableConfigValue, (Object)versionNodeName, (Object)version);
            retval = new MavenProblemInfo(problemMsg, 1, location);
        }
        return retval;
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IWebProject webproject;
        HookDescriptorHelper hookDescriptor;
        String customJSPFolder;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)Msgs.configuringLiferayProject, (Object)request.getProject()), 100);
        Plugin liferayMavenPlugin = MavenUtil.getPlugin(request.getMavenProjectFacade(), "com.liferay.maven.plugins:liferay-maven-plugin", monitor);
        if (!this.shouldConfigure(liferayMavenPlugin, request)) {
            monitor.done();
            return;
        }
        IProject project = request.getProject();
        IFile pomFile = project.getFile("pom.xml");
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)false, (IProgressMonitor)monitor);
        this.removeLiferayMavenMarkers(project);
        monitor.worked(25);
        MavenProject mavenProject = request.getMavenProject();
        List<MavenProblemInfo> errors = this.findLiferayMavenPluginProblems(project, request, monitor);
        if (errors.size() > 0) {
            try {
                this.markerManager.addErrorMarkers((IResource)pomFile, "com.liferay.ide.maven.core.configurationProblem", errors);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        monitor.worked(25);
        MavenProblemInfo installProblem = null;
        if (this.shouldInstallNewLiferayFacet(mavenProject, facetedProject)) {
            installProblem = this.installNewLiferayFacet(facetedProject, request, monitor);
        }
        if (this.shouldAddLiferayNature(mavenProject, facetedProject)) {
            LiferayNature.addLiferayNature((IProject)project, (IProgressMonitor)monitor);
        }
        monitor.worked(25);
        if (installProblem != null) {
            this.markerManager.addMarker((IResource)pomFile, "com.liferay.ide.maven.core.configurationProblem", installProblem.getMessage(), installProblem.getLocation().getLineNumber(), 1);
        } else {
            IVirtualComponent component;
            String pluginType = MavenUtil.getLiferayMavenPluginType(mavenProject);
            IVirtualComponent projectComponent = ComponentCore.createComponent((IProject)project);
            try {
                if (projectComponent != null) {
                    String deployedName = projectComponent.getDeployedName();
                    Pattern VERSION_PATTERN = Pattern.compile("^(.*)-([0-9]\\.[0-9]\\.[0-9])(?:-SNAPSHOT)?$");
                    Matcher m = VERSION_PATTERN.matcher(deployedName);
                    if (m.matches()) {
                        deployedName = m.group(1);
                        this.configureDeployedName(project, deployedName);
                    }
                    if (pluginType != null) {
                        IEclipsePreferences prefs;
                        boolean setMavenPluginSuffix;
                        String oldContextRoot;
                        String pluginTypeSuffix = "-" + pluginType;
                        String deployedFileName = String.valueOf(project.getName()) + pluginTypeSuffix;
                        if (deployedName == null || deployedName != null && !deployedName.endsWith(pluginTypeSuffix)) {
                            this.configureDeployedName(project, deployedFileName);
                        }
                        if (((oldContextRoot = ComponentUtilities.getServerContextRoot((IProject)project)) == null || oldContextRoot != null && !oldContextRoot.endsWith(pluginTypeSuffix)) && (setMavenPluginSuffix = (prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.maven.core")).getBoolean("add-maven-plugin-suffix", false))) {
                            ComponentUtilities.setServerContextRoot((IProject)project, (String)deployedFileName);
                        }
                    }
                }
            }
            catch (Exception e) {
                LiferayMavenCore.logError("Unable to configure deployed name for project " + project.getName(), e);
            }
            if ("theme".equals(pluginType) && (component = ComponentCore.createComponent((IProject)project, (boolean)true)) != null) {
                WarPluginConfiguration config = new WarPluginConfiguration(mavenProject, project);
                String warSourceDirectory = config.getWarSourceDirectory();
                IFolder contentFolder = project.getFolder(warSourceDirectory);
                IPath warPath = ROOT_PATH.append(contentFolder.getProjectRelativePath());
                IPath themeFolder = ROOT_PATH.append(LiferayMavenProjectConfigurator.getThemeTargetFolder(mavenProject, project));
                WTPProjectsUtil.insertLinkBefore((IProject)project, (IPath)themeFolder, (IPath)warPath, (IPath)ROOT_PATH, (IProgressMonitor)monitor);
            }
        }
        if (project != null && ProjectUtil.isHookProject((IProject)project) && (customJSPFolder = (hookDescriptor = new HookDescriptorHelper(project)).getCustomJSPFolder(null)) != null && (webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project)) != null && webproject.getDefaultDocrootFolder() != null) {
            IFolder docFolder = webproject.getDefaultDocrootFolder();
            IPath newPath = Path.fromOSString((String)customJSPFolder);
            IPath pathValue = docFolder.getFullPath().append(newPath);
            boolean disableCustomJspValidation = LiferayMavenCore.getPreferenceBoolean("disable-custom-jsp-validation");
            if (disableCustomJspValidation) {
                HookUtil.configureJSPSyntaxValidationExclude((IProject)project, (IFolder)project.getFolder(pathValue.makeRelativeTo(project.getFullPath())), (boolean)true);
            }
        }
        monitor.worked(25);
        monitor.done();
    }

    private boolean shouldAddLiferayNature(MavenProject mavenProject, IFacetedProject facetedProject) {
        boolean isLayoutTemplateProject = false;
        IProject project = facetedProject.getProject();
        if (project != null && project.exists() && project.getFile("src/main/webapp/WEB-INF/liferay-layout-templates.xml").exists()) {
            isLayoutTemplateProject = true;
        }
        return mavenProject.getPlugin("biz.aQute.bnd:bnd-maven-plugin") != null || mavenProject.getPlugin("org.apache.felix:maven-bundle-plugin") != null || mavenProject.getPlugin("com.liferay:com.liferay.portal.tools.theme.builder") != null || isLayoutTemplateProject;
    }

    public static IPath getThemeTargetFolder(MavenProject mavenProject, IProject project) {
        return MavenUtil.getM2eLiferayFolder(mavenProject, project).append("theme-resources");
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    protected void configureDeployedName(IProject project, String deployedFileName) {
        int extSeparatorPos = deployedFileName.lastIndexOf(46);
        String deployedName = extSeparatorPos > -1 ? deployedFileName.substring(0, extSeparatorPos) : deployedFileName;
        IVirtualComponent projectComponent = ComponentCore.createComponent((IProject)project);
        if (projectComponent != null && !deployedName.equals(projectComponent.getDeployedName())) {
            StructureEdit moduleCore = null;
            try {
                WorkbenchComponent component;
                moduleCore = StructureEdit.getStructureEditForWrite((IProject)project);
                if (moduleCore != null && (component = moduleCore.getComponent()) != null) {
                    component.setName(deployedName);
                    moduleCore.saveIfNecessary(null);
                }
            }
            finally {
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
            }
        }
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    private List<MavenProblemInfo> findLiferayMavenPluginProblems(IProject project, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        ArrayList<MavenProblemInfo> warnings = new ArrayList<MavenProblemInfo>();
        Plugin liferayMavenPlugin = MavenUtil.getPlugin(request.getMavenProjectFacade(), "com.liferay.maven.plugins:liferay-maven-plugin", monitor);
        if (liferayMavenPlugin != null) {
            String[] configDirParams;
            Version mavenPluginVersion;
            Xpp3Dom config = (Xpp3Dom)liferayMavenPlugin.getConfiguration();
            MavenProblemInfo validLiferayProblemInfo = this.checkValidVersion(liferayMavenPlugin, config, "liferayVersion");
            if (validLiferayProblemInfo != null) {
                warnings.add(validLiferayProblemInfo);
            }
            if ((mavenPluginVersion = new Version(MavenUtil.getVersion(liferayMavenPlugin.getVersion()))) == null || mavenPluginVersion.equals((Object)ILiferayConstants.EMPTY_VERSION)) {
                SourceLocation location = SourceLocationHelper.findLocation((Plugin)liferayMavenPlugin, (String)"version");
                String problemMsg = NLS.bind((String)Msgs.invalidVersion, (Object)"liferay-maven-plugin", (Object)liferayMavenPlugin.getVersion());
                MavenProblemInfo versionProblem = new MavenProblemInfo(problemMsg, 1, location);
                warnings.add(versionProblem);
            }
            String[] stringArray = configDirParams = new String[]{"appServerPortalDir"};
            int n = configDirParams.length;
            int n2 = 0;
            while (n2 < n) {
                String configParam = stringArray[n2];
                MavenProblemInfo configProblemInfo = this.checkValidConfigDir(liferayMavenPlugin, config, configParam);
                if (configProblemInfo != null) {
                    warnings.add(configProblemInfo);
                }
                ++n2;
            }
        }
        return warnings;
    }

    private IProjectFacetVersion getLiferayProjectFacet(IFacetedProject facetedProject) {
        IProjectFacetVersion retval = null;
        if (facetedProject != null) {
            for (IProjectFacetVersion fv : facetedProject.getProjectFacets()) {
                if (!fv.getProjectFacet().getId().contains("liferay.")) continue;
                retval = fv;
                break;
            }
        }
        return retval;
    }

    private IFacetedProject.Action getNewLiferayFacetInstallAction(String pluginType) {
        IFacetedProject.Action retval = null;
        IProjectFacetVersion newFacet = null;
        Object dataModel = null;
        if ("portlet".equals(pluginType)) {
            newFacet = IPluginFacetConstants.LIFERAY_PORTLET_PROJECT_FACET.getDefaultVersion();
            dataModel = new MavenPortletPluginFacetInstallProvider();
        } else if ("hook".equals(pluginType)) {
            newFacet = IPluginFacetConstants.LIFERAY_HOOK_PROJECT_FACET.getDefaultVersion();
            dataModel = new MavenHookPluginFacetInstallProvider();
        } else if ("ext".equals(pluginType)) {
            newFacet = IPluginFacetConstants.LIFERAY_EXT_PROJECT_FACET.getDefaultVersion();
            dataModel = new MavenExtPluginFacetInstallProvider();
        } else if ("layouttpl".equals(pluginType)) {
            newFacet = IPluginFacetConstants.LIFERAY_LAYOUTTPL_PROJECT_FACET.getDefaultVersion();
            dataModel = new MavenLayoutTplPluginFacetInstallProvider();
        } else if ("theme".equals(pluginType)) {
            newFacet = IPluginFacetConstants.LIFERAY_THEME_PROJECT_FACET.getDefaultVersion();
            dataModel = new MavenThemePluginFacetInstallProvider();
        } else if ("web".equals(pluginType)) {
            newFacet = IPluginFacetConstants.LIFERAY_WEB_PROJECT_FACET.getDefaultVersion();
            dataModel = new MavenWebPluginFacetInstallProvider();
        }
        if (newFacet != null) {
            IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)dataModel);
            retval = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, newFacet, (Object)config);
        }
        return retval;
    }

    private MavenProblemInfo installNewLiferayFacet(IFacetedProject facetedProject, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProblemInfo retval = null;
        String pluginType = MavenUtil.getLiferayMavenPluginType(request.getMavenProject());
        if (pluginType == null) {
            pluginType = "portlet";
        }
        Plugin liferayMavenPlugin = MavenUtil.getPlugin(request.getMavenProjectFacade(), "com.liferay.maven.plugins:liferay-maven-plugin", monitor);
        IFacetedProject.Action action = this.getNewLiferayFacetInstallAction(pluginType);
        if (action != null) {
            try {
                facetedProject.modify(Collections.singleton(action), monitor);
            }
            catch (Exception e) {
                try {
                    SourceLocation location = SourceLocationHelper.findLocation((Plugin)liferayMavenPlugin, (String)"configuration");
                    String problemMsg = NLS.bind((String)Msgs.facetInstallError, (Object)pluginType, (Object)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
                    retval = new MavenProblemInfo(location, (Throwable)e);
                    retval.setMessage(problemMsg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LiferayMavenCore.logError("Unable to install liferay facet " + action.getProjectFacetVersion(), e.getCause());
            }
        }
        return retval;
    }

    private void removeLiferayMavenMarkers(IProject project) throws CoreException {
        this.mavenMarkerManager.deleteMarkers((IResource)project, "com.liferay.ide.maven.core.configurationProblem");
    }

    private boolean shouldConfigure(Plugin liferayMavenPlugin, ProjectConfigurationRequest request) {
        IProject project = request.getProject();
        MavenProject mavenProject = request.getMavenProject();
        boolean configureAsLiferayPlugin = liferayMavenPlugin != null;
        IFolder warSourceDir = this.warSourceDirectory(project, mavenProject);
        if (!configureAsLiferayPlugin && warSourceDir != null) {
            IPath baseDir = warSourceDir.getRawLocation();
            String[] includes = new String[]{"**/liferay*.xml", "**/liferay*.properties"};
            DirectoryScanner dirScanner = new DirectoryScanner();
            dirScanner.setBasedir(baseDir.toFile());
            dirScanner.setIncludes(includes);
            dirScanner.scan();
            String[] liferayProjectFiles = dirScanner.getIncludedFiles();
            configureAsLiferayPlugin = liferayProjectFiles != null && liferayProjectFiles.length > 0;
        }
        return configureAsLiferayPlugin;
    }

    private boolean shouldInstallNewLiferayFacet(MavenProject mavenProject, IFacetedProject facetedProject) {
        return this.getLiferayProjectFacet(facetedProject) == null;
    }

    private IFolder warSourceDirectory(IProject project, MavenProject mavenProject) {
        Xpp3Dom[] warSourceDirs;
        IFolder retval = null;
        Xpp3Dom warPluginConfiguration = (Xpp3Dom)mavenProject.getPlugin(MAVEN_WAR_PLUGIN_KEY).getConfiguration();
        if (warPluginConfiguration != null && (warSourceDirs = warPluginConfiguration.getChildren("warSourceDirectory")) != null && warSourceDirs.length > 0) {
            String resourceLocation = warSourceDirs[0].getValue();
            retval = project.getFolder(resourceLocation);
        }
        if (retval == null) {
            retval = project.getFolder(WAR_SOURCE_FOLDER);
        }
        return retval;
    }

    private static class Msgs
    extends NLS {
        public static String configuringLiferayProject;
        public static String emptyConfigValue;
        public static String facetInstallError;
        public static String invalidVersion;
        public static String missingConfigValue;
        public static String unusableConfigValue;

        static {
            Msgs.initializeMessages((String)LiferayMavenProjectConfigurator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

