/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.maven.core.FacetedMavenBundleProject;
import com.liferay.ide.maven.core.FacetedMavenProject;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProject;
import com.liferay.ide.maven.core.MavenBundlePluginProject;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.aether.AetherUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.descriptor.UpdateDescriptorVersionOperation;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.project.core.model.ProfileLocation;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import com.liferay.ide.server.util.ComponentUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.settings.Profile;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class LiferayMavenProjectProvider
extends AbstractLiferayProjectProvider {
    private static final String[] fileNames = new String[]{"liferay-portlet.xml", "liferay-display.xml", "service.xml", "liferay-hook.xml", "liferay-layout-templates.xml", "liferay-look-and-feel.xml", "liferay-portlet-ext.xml"};
    private static final Pattern publicid_pattern = Pattern.compile("-\\//(?:[a-z][a-z]+)\\//(?:[a-z][a-z]+)[\\s+(?:[a-z][a-z0-9_]*)]*\\s+(\\d\\.\\d\\.\\d)\\//(?:[a-z][a-z]+)", 34);
    private static final Pattern systemid_pattern = Pattern.compile("^http://www.liferay.com/dtd/[-A-Za-z0-9+&@#/%?=~_()]*(\\d_\\d_\\d).dtd", 34);

    public LiferayMavenProjectProvider() {
        super(new Class[]{IProject.class});
    }

    public <T> List<T> getData(String key, Class<T> type, Object ... params) {
        List<T> retval = null;
        if ("profileIds".equals(key)) {
            ArrayList<T> profileIds = new ArrayList<T>();
            try {
                List profiles = MavenPlugin.getMaven().getSettings().getProfiles();
                for (Profile profile : profiles) {
                    if (profile.getActivation() != null && profile.getActivation().isActiveByDefault()) continue;
                    profileIds.add(type.cast(profile.getId()));
                }
                if (params[0] != null && params[0] instanceof File) {
                    File locationDir = (File)params[0];
                    File pomFile = new File(locationDir, "pom.xml");
                    if (!pomFile.exists() && locationDir.getParentFile().exists()) {
                        pomFile = new File(locationDir.getParentFile(), "pom.xml");
                    }
                    if (pomFile.exists()) {
                        IMaven maven = MavenPlugin.getMaven();
                        Model model = maven.readModel(pomFile);
                        File parentDir = pomFile.getParentFile();
                        while (model != null) {
                            for (org.apache.maven.model.Profile p : model.getProfiles()) {
                                profileIds.add(type.cast(p.getId()));
                            }
                            if ((parentDir = parentDir.getParentFile()) == null || !parentDir.exists()) continue;
                            try {
                                model = maven.readModel(new File(parentDir, "pom.xml"));
                            }
                            catch (Exception e) {
                                model = null;
                            }
                        }
                    }
                }
            }
            catch (CoreException e) {
                LiferayMavenCore.logError(e);
            }
            retval = profileIds;
        } else if ("liferayVersions".equals(key)) {
            ArrayList<T> possibleVersions = new ArrayList<T>();
            RepositorySystem system = AetherUtil.newRepositorySystem();
            DefaultRepositorySystemSession session = AetherUtil.newRepositorySystemSession(system);
            String groupId = params[0].toString();
            String artifactId = params[1].toString();
            String coords = String.valueOf(groupId) + ":" + artifactId + ":[6,)";
            DefaultArtifact artifact = new DefaultArtifact(coords);
            VersionRangeRequest rangeRequest = new VersionRangeRequest();
            rangeRequest.setArtifact((Artifact)artifact);
            rangeRequest.addRepository(AetherUtil.newCentralRepository());
            rangeRequest.addRepository(AetherUtil.newLiferayRepository());
            try {
                VersionRangeResult rangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
                List versions = rangeResult.getVersions();
                for (Version version : versions) {
                    String val = version.toString();
                    if ("6.2.0".equals(val)) continue;
                    possibleVersions.add(type.cast(val));
                }
                retval = possibleVersions;
            }
            catch (VersionRangeResolutionException versionRangeResolutionException) {}
        } else if ("parentVersion".equals(key)) {
            ArrayList<T> version = new ArrayList<T>();
            File locationDir = (File)params[0];
            File parentPom = new File(locationDir, "pom.xml");
            if (parentPom.exists()) {
                try {
                    IMaven maven = MavenPlugin.getMaven();
                    Model model = maven.readModel(parentPom);
                    version.add(type.cast(model.getVersion()));
                    retval = version;
                }
                catch (CoreException e) {
                    LiferayMavenCore.logError("unable to get parent version", e);
                }
            }
        } else if ("parentGroupId".equals(key)) {
            ArrayList<T> groupId = new ArrayList<T>();
            File locationDir = (File)params[0];
            File parentPom = new File(locationDir, "pom.xml");
            if (parentPom.exists()) {
                try {
                    IMaven maven = MavenPlugin.getMaven();
                    Model model = maven.readModel(parentPom);
                    groupId.add(type.cast(model.getGroupId()));
                    retval = groupId;
                }
                catch (CoreException e) {
                    LiferayMavenCore.logError("unable to get parent groupId", e);
                }
            }
        } else if ("archetypeGAV".equals(key)) {
            String frameworkType = (String)params[0];
            String value = LiferayMavenCore.getPreferenceString("archetype-gav-" + frameworkType, "");
            retval = Collections.singletonList(type.cast(value));
        }
        return retval;
    }

    private IFile[] getLiferayMetaFiles(IProject project) {
        ArrayList files = new ArrayList();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            files.addAll(new SearchFilesVisitor().searchFiles((IResource)project, name));
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    private String getNewDoctTypeSetting(String doctypeSetting, String newValue, Pattern p) {
        String newDoctTypeSetting = null;
        Matcher m = p.matcher(doctypeSetting);
        if (m.find()) {
            String oldVersionString = m.group(m.groupCount());
            newDoctTypeSetting = doctypeSetting.replace(oldVersionString, newValue);
        }
        return newDoctTypeSetting;
    }

    protected String getNewLiferayProfilesPluginVersion(String[] activeProfiles, List<NewLiferayProfile> newLiferayProfiles, String archetypeVersion) {
        org.osgi.framework.Version minVersion = new org.osgi.framework.Version(archetypeVersion.substring(0, 3));
        try {
            List profiles = MavenPlugin.getMaven().getSettings().getProfiles();
            org.osgi.framework.Version minNewVersion = new org.osgi.framework.Version(archetypeVersion.substring(0, 3));
            org.osgi.framework.Version minExistedVersion = new org.osgi.framework.Version(archetypeVersion.substring(0, 3));
            String[] stringArray = activeProfiles;
            int n = activeProfiles.length;
            int n2 = 0;
            while (n2 < n) {
                String activeProfile = stringArray[n2];
                for (NewLiferayProfile newProfile : newLiferayProfiles) {
                    org.osgi.framework.Version shortPluginVersion;
                    if (!activeProfile.equals(newProfile.getId().content())) continue;
                    String liferayVersion = (String)newProfile.getLiferayVersion().content();
                    org.osgi.framework.Version shortLiferayVersion = new org.osgi.framework.Version(liferayVersion.substring(0, 3));
                    org.osgi.framework.Version version = minNewVersion = shortLiferayVersion.compareTo(shortPluginVersion = new org.osgi.framework.Version(archetypeVersion.substring(0, 3))) < 0 ? shortLiferayVersion : shortPluginVersion;
                }
                minVersion = minVersion.compareTo(minNewVersion) < 0 ? minVersion : minNewVersion;
                for (Profile existProfile : profiles) {
                    org.osgi.framework.Version shortPluginVersion;
                    if (!activeProfile.equals(existProfile.getId())) continue;
                    Properties properties = existProfile.getProperties();
                    String liferayVersion = properties.getProperty("liferay.version");
                    String pluginVersion = properties.getProperty("liferay.maven.plugin.version");
                    if (pluginVersion == null || liferayVersion == null) continue;
                    org.osgi.framework.Version shortLiferayVersion = new org.osgi.framework.Version(liferayVersion.substring(0, 3));
                    org.osgi.framework.Version version = minExistedVersion = shortLiferayVersion.compareTo(shortPluginVersion = new org.osgi.framework.Version(pluginVersion.substring(0, 3))) < 0 ? shortLiferayVersion : shortPluginVersion;
                }
                minVersion = minVersion.compareTo(minExistedVersion) < 0 ? minVersion : minExistedVersion;
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minVersion.toString();
    }

    protected List<NewLiferayProfile> getNewProfilesToSave(String[] activeProfiles, List<NewLiferayProfile> newLiferayProfiles, ProfileLocation location) {
        ArrayList<NewLiferayProfile> profilesToSave = new ArrayList<NewLiferayProfile>();
        String[] stringArray = activeProfiles;
        int n = activeProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            String activeProfile = stringArray[n2];
            for (NewLiferayProfile newProfile : newLiferayProfiles) {
                if (!activeProfile.equals(newProfile.getId().content()) || !((ProfileLocation)newProfile.getProfileLocation().content()).equals((Object)location)) continue;
                profilesToSave.add(newProfile);
            }
            ++n2;
        }
        return profilesToSave;
    }

    public ILiferayProject provide(Object adaptable) {
        if (adaptable instanceof IProject) {
            IProject project = (IProject)adaptable;
            try {
                if (MavenUtil.isMavenProject(project)) {
                    boolean hasLiferayNature = LiferayNature.hasNature((IProject)project);
                    boolean hasLiferayFacet = ComponentUtil.hasLiferayFacet((IProject)project);
                    if ((hasLiferayNature || MavenUtil.hasDependency(project, "com.liferay.portal", "com.liferay.portal.kernel") || MavenUtil.hasDependency(project, "com.liferay.faces", "com.liferay.faces.bridge.ext")) && hasLiferayFacet) {
                        return new FacetedMavenBundleProject(project);
                    }
                    if (hasLiferayFacet) {
                        return new FacetedMavenProject(project);
                    }
                    if (hasLiferayNature) {
                        return new MavenBundlePluginProject(project);
                    }
                    return new LiferayMavenProject(project){

                        public IFile getDescriptorFile(String name) {
                            return null;
                        }

                        public IFolder[] getSourceFolders() {
                            return null;
                        }
                    };
                }
            }
            catch (CoreException e) {
                LiferayMavenCore.logError("Unable to create ILiferayProject from maven project " + project.getName(), e);
            }
        }
        return null;
    }

    protected void updateDtdVersion(IProject project, String dtdVersion, String archetypeVesion) {
        IFile[] metaFiles;
        String tmpPublicId = dtdVersion;
        String tmpSystemId = dtdVersion.replaceAll("\\.", "_");
        IStructuredModel editModel = null;
        IFile[] iFileArray = metaFiles = this.getLiferayMetaFiles(project);
        int n = metaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                IFile file = iFileArray[n2];
                try {
                    try {
                        editModel = StructuredModelManager.getModelManager().getModelForEdit(file);
                        if (editModel != null && editModel instanceof IDOMModel) {
                            String systemId;
                            String newSystemId;
                            IDOMDocument xmlDocument = ((IDOMModel)editModel).getDocument();
                            DocumentTypeImpl docType = (DocumentTypeImpl)xmlDocument.getDoctype();
                            String publicId = docType.getPublicId();
                            String newPublicId = this.getNewDoctTypeSetting(publicId, tmpPublicId, publicid_pattern);
                            if (newPublicId != null) {
                                docType.setPublicId(newPublicId);
                            }
                            if ((newSystemId = this.getNewDoctTypeSetting(systemId = docType.getSystemId(), tmpSystemId, systemid_pattern)) != null) {
                                docType.setSystemId(newSystemId);
                            }
                            editModel.save();
                        }
                    }
                    catch (Exception e) {
                        IStatus error = ProjectCore.createErrorStatus((String)("Unable to upgrade deployment meta file for " + file.getName()), (Throwable)e);
                        ProjectCore.logError((IStatus)error);
                        if (editModel != null) {
                            editModel.releaseFromEdit();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (editModel != null) {
                        editModel.releaseFromEdit();
                    }
                    throw throwable;
                }
                if (editModel != null) {
                    editModel.releaseFromEdit();
                }
            }
            ++n2;
        }
        ProjectCore.operate((IProject)project, UpdateDescriptorVersionOperation.class, (Object[])new Object[]{archetypeVesion, dtdVersion});
    }
}

