/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProjectProvider;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceProjectProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.sapphire.platform.PathBridge;

public class LiferayMavenWorkspaceProjectProvider
extends LiferayMavenProjectProvider
implements NewLiferayWorkspaceProjectProvider<NewLiferayWorkspaceOp> {
    public IStatus createNewProject(NewLiferayWorkspaceOp op, IProgressMonitor monitor) throws CoreException {
        String projectName;
        IStatus retval = Status.OK_STATUS;
        IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
        IPath location = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)op.getLocation().content()));
        String groupId = projectName = (String)op.getWorkspaceName().content();
        String artifactId = projectName;
        String version = "1.0.0-SNAPSHOT";
        String javaPackage = "";
        String archetypeArtifactId = this.getData("archetypeGAV", String.class, "").get(0);
        Archetype archetype = new Archetype();
        String[] gav = archetypeArtifactId.split(":");
        String archetypeVersion = gav[gav.length - 1];
        archetype.setGroupId(gav[0]);
        archetype.setArtifactId(gav[1]);
        archetype.setVersion(archetypeVersion);
        Properties properties = new Properties();
        ResolverConfiguration resolverConfig = new ResolverConfiguration();
        ProjectImportConfiguration configuration = new ProjectImportConfiguration(resolverConfig);
        List newProjects = projectConfigurationManager.createArchetypeProjects(location, archetype, groupId, artifactId, "1.0.0-SNAPSHOT", "", properties, configuration, monitor);
        if (newProjects == null || newProjects.size() == 0) {
            retval = LiferayMavenCore.createErrorStatus("Unable to create liferay workspace project from archetype.");
        } else {
            for (IProject newProject : newProjects) {
                String[] gradleFiles;
                String[] stringArray = gradleFiles = new String[]{"build.gradle", "settings.gradle", "gradle.properties"};
                int n = gradleFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    IFile gradleFile = newProject.getFile(path);
                    if (gradleFile.exists()) {
                        gradleFile.delete(true, monitor);
                    }
                    ++n2;
                }
            }
        }
        boolean isInitBundle = (Boolean)op.getProvisionLiferayBundle().content();
        if (retval.isOK() && isInitBundle) {
            IProject workspaceProject = ProjectUtil.getProject((String)projectName);
            String bundleUrl = (String)op.getBundleUrl().content();
            MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(workspaceProject);
            mavenProjectBuilder.execInitBundle(workspaceProject, "init-bundle", bundleUrl, monitor);
        }
        return retval;
    }

    @Override
    public <T> List<T> getData(String key, Class<T> type, Object ... params) {
        if ("archetypeGAV".equals(key) && type.equals(String.class)) {
            ArrayList<T> retval = new ArrayList<T>();
            String gav = LiferayMavenCore.getPreferenceString("archetype-project-template-workspace", "");
            if (CoreUtil.empty((String)gav)) {
                gav = "com.liferay:com.liferay.project.templates.workspace:1.0.2";
            }
            retval.add(type.cast(gav));
            return retval;
        }
        return super.getData(key, type, params);
    }

    public IStatus importProject(String location, IProgressMonitor monitor, boolean initBundle, String bundleUrl) {
        IStatus retval = Status.OK_STATUS;
        Path path = new Path(location);
        String projectName = path.lastSegment();
        try {
            MavenUtil.importProject(location, monitor);
            if (initBundle) {
                IProject workspaceProject = ProjectUtil.getProject((String)projectName);
                MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(workspaceProject);
                mavenProjectBuilder.execInitBundle(workspaceProject, "init-bundle", bundleUrl, monitor);
            }
        }
        catch (Exception e) {
            retval = ProjectCore.createErrorStatus((Exception)e);
        }
        return retval;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval = Status.OK_STATUS;
        return retval;
    }
}

