/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.IMavenProject;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.server.util.LiferayPortalValueLoader;
import com.liferay.ide.server.util.ServerUtil;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class LiferayPortalMaven
implements ILiferayPortal {
    private final IMavenProject lrMvnProject;

    public LiferayPortalMaven(IMavenProject project) {
        this.lrMvnProject = project;
    }

    public IPath getAppServerPortalDir() {
        Path retval = null;
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.lrMvnProject.getProject());
        if (projectFacade != null) {
            try {
                MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                String appServerPortalDir = MavenUtil.getLiferayMavenPluginConfig(mavenProject, "appServerPortalDir");
                if (!CoreUtil.isNullOrEmpty((String)appServerPortalDir)) {
                    retval = new Path(appServerPortalDir);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return retval;
    }

    public String[] getHookSupportedProperties() {
        return new LiferayPortalValueLoader(this.getAppServerPortalDir(), this.lrMvnProject.getUserLibs()).loadHookPropertiesFromClass();
    }

    public Properties getPortletCategories() {
        Properties retval = null;
        IPath appServerPortalDir = this.getAppServerPortalDir();
        if (appServerPortalDir != null && appServerPortalDir.toFile().exists()) {
            retval = ServerUtil.getPortletCategories((IPath)appServerPortalDir);
        }
        if (retval == null) {
            retval = new Properties();
            retval.put("category.sample", "Sample");
        }
        return retval;
    }

    public Properties getPortletEntryCategories() {
        String portalVersion;
        Properties retval = null;
        IPath appServerPortalDir = this.getAppServerPortalDir();
        if (appServerPortalDir != null && appServerPortalDir.toFile().exists() && (portalVersion = this.getVersion()) != null) {
            retval = ServerUtil.getEntryCategories((IPath)appServerPortalDir, (String)portalVersion);
        }
        return retval;
    }

    public String getVersion() {
        String retval = null;
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.lrMvnProject.getProject());
        if (projectFacade != null) {
            try {
                List deps;
                MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                String liferayVersion = MavenUtil.getLiferayMavenPluginConfig(mavenProject, "liferayVersion");
                if (liferayVersion == null && (liferayVersion = mavenProject.getProperties().getProperty("liferay.version")) == null && (deps = mavenProject.getDependencies()) != null) {
                    for (Dependency dep : deps) {
                        if (!dep.getArtifactId().startsWith("portal-") || !dep.getGroupId().startsWith("com.liferay")) continue;
                        liferayVersion = dep.getVersion();
                        break;
                    }
                }
                if (liferayVersion != null) {
                    retval = MavenUtil.getVersion(liferayVersion);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return retval;
    }
}

