/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProjectProvider;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentOp;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentOpMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class MavenModuleFragmentProjectProvider
extends LiferayMavenProjectProvider
implements NewLiferayProjectProvider<NewModuleFragmentOp> {
    public IStatus createNewProject(NewModuleFragmentOp op, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        String projectName = (String)op.getProjectName().content();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        String[] bsnAndVersion = NewModuleFragmentOpMethods.getBsnAndVersion((NewModuleFragmentOp)op);
        String hostBundleSymbolicName = bsnAndVersion[0];
        String hostBundleVersion = bsnAndVersion[1];
        String groupId = (String)op.getGroupId().content();
        String artifactId = projectName;
        String version = (String)op.getArtifactVersion().content();
        String javaPackage = "";
        String archetypeArtifactId = this.getData("archetypeGAV", String.class, "").get(0);
        Archetype archetype = new Archetype();
        String[] gav = archetypeArtifactId.split(":");
        String archetypeVersion = gav[gav.length - 1];
        archetype.setGroupId(gav[0]);
        archetype.setArtifactId(gav[1]);
        archetype.setVersion(archetypeVersion);
        Properties properties = new Properties();
        properties.put("package", artifactId);
        properties.put("hostBundleSymbolicName", hostBundleSymbolicName);
        properties.put("hostBundleVersion", hostBundleVersion);
        properties.put("buildType", "maven");
        properties.put("projectType", "standalone");
        IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
        ResolverConfiguration resolverConfig = new ResolverConfiguration();
        ProjectImportConfiguration configuration = new ProjectImportConfiguration(resolverConfig);
        List newProjects = projectConfigurationManager.createArchetypeProjects(location, archetype, groupId, artifactId, version, "", properties, configuration, monitor);
        NewModuleFragmentOpMethods.copyOverrideFiles((NewModuleFragmentOp)op);
        if (newProjects == null || newProjects.size() == 0) {
            return LiferayMavenCore.createErrorStatus("Unable to create fragment project from archetype.");
        }
        for (IProject newProject : newProjects) {
            String[] gradleFiles;
            String[] stringArray = gradleFiles = new String[]{"build.gradle", "settings.gradle"};
            int n = gradleFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                IFile gradleFile = newProject.getFile(path);
                if (gradleFile.exists()) {
                    gradleFile.delete(true, monitor);
                }
                ++n2;
            }
            newProject.refreshLocal(2, null);
        }
        return retval;
    }

    @Override
    public <T> List<T> getData(String key, Class<T> type, Object ... params) {
        if ("archetypeGAV".equals(key) && type.equals(String.class) && params.length == 1) {
            ArrayList<T> retval = new ArrayList<T>();
            String gav = LiferayMavenCore.getPreferenceString("archetype-project-template-fragment", "");
            if (CoreUtil.empty((String)gav)) {
                gav = "com.liferay:com.liferay.project.templates.fragment:1.0.1";
            }
            retval.add(type.cast(gav));
            return retval;
        }
        return super.getData(key, type, params);
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        return Status.OK_STATUS;
    }
}

