/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProjectProvider;
import com.liferay.ide.maven.core.aether.AetherUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.jsf.NewLiferayJSFModuleProjectOp;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.wagon.events.TransferListener;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class NewMavenJSFModuleProjectProvider
extends LiferayMavenProjectProvider
implements NewLiferayProjectProvider<NewLiferayJSFModuleProjectOp> {
    protected IPath createArchetypeProject(NewLiferayJSFModuleProjectOp op, IProgressMonitor monitor) throws CoreException {
        IPath projectLocation = null;
        String javaPackage = "com.example";
        String projectName = (String)op.getProjectName().content();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        if (location.lastSegment().equals(projectName)) {
            location = location.removeLastSegments(1);
        }
        String groupId = (String)op.getProjectName().content();
        String artifactId = (String)op.getProjectName().content();
        String version = "1.0.0";
        String archetypeArtifactId = (String)op.getArchetype().content();
        Archetype archetype = new Archetype();
        String[] gav = archetypeArtifactId.split(":");
        String archetypeVersion = gav[gav.length - 1];
        archetype.setGroupId(gav[0]);
        archetype.setArtifactId(gav[1]);
        archetype.setVersion(archetypeVersion);
        Artifact artifact = AetherUtil.getLatestAvailableArtifact(archetypeArtifactId);
        Properties properties = new Properties();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (location == null) {
            location = workspaceRoot.getLocation();
        }
        try {
            ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setTransferListener((TransferListener)MavenPluginActivator.getDefault().getMaven().createTransferListener(monitor)).setArchetypeGroupId(artifact.getGroupId()).setArchetypeArtifactId(artifact.getArtifactId()).setArchetypeVersion(artifact.getVersion()).setArchetypeRepository(AetherUtil.newCentralRepository().getUrl()).setGroupId(groupId).setArtifactId(artifactId).setVersion("1.0.0").setPackage("com.example").setLocalRepository(MavenPluginActivator.getDefault().getMaven().getLocalRepository()).setRemoteArtifactRepositories(MavenPluginActivator.getDefault().getMaven().getArtifactRepositories(true)).setProperties(properties).setOutputDirectory(location.toPortableString());
            ArchetypeGenerationResult result = this.getArchetyper().generateProjectFromArchetype(request);
            Exception cause = result.getCause();
            if (cause != null) {
                throw new CoreException(LiferayCore.createErrorStatus((String)"Unable to create project from archetype."));
            }
            projectLocation = location.append(artifactId);
            if (!projectLocation.toFile().exists()) {
                throw new CoreException(LiferayCore.createErrorStatus((String)"Can't create gradle JSF project. "));
            }
        }
        catch (Exception e) {
            throw new CoreException(LiferayCore.createErrorStatus((String)"Failed to create JSF project. ", (Throwable)e));
        }
        return projectLocation;
    }

    public IStatus createNewProject(NewLiferayJSFModuleProjectOp op, IProgressMonitor monitor) throws CoreException {
        ILiferayProjectImporter importer;
        IStatus canImport;
        IStatus retval = null;
        IPath projectLocation = this.createArchetypeProject(op, monitor);
        IPath buildGradle = projectLocation.append("build.gradle");
        if (buildGradle.toFile().exists()) {
            buildGradle.toFile().delete();
        }
        if ((canImport = (importer = LiferayCore.getImporter((String)"maven")).canImport(projectLocation.toOSString())).getCode() != 4) {
            importer.importProjects(projectLocation.toOSString(), monitor);
        }
        retval = Status.OK_STATUS;
        return retval;
    }

    private Version extractLatestVersion(String artifactId) {
        Version maxVersion = new Version("5.0.1");
        try {
            JSONObject responseJson;
            Object docs;
            JSONObject resultJson;
            Object response;
            String responseString = this.getHttpResponse("http://search.maven.org/solrsearch/select?q=g:com.liferay.faces.archetype+AND+a:" + artifactId + "&rows=20&wt=json");
            Object result = this.getJSONResponse(responseString);
            if (result instanceof JSONObject && (response = (resultJson = (JSONObject)result).get("response")) != null && (docs = (responseJson = (JSONObject)response).get("docs")) != null && docs instanceof JSONArray) {
                JSONArray docsJson = (JSONArray)docs;
                int i = 0;
                while (i < docsJson.length()) {
                    JSONObject docJson = (JSONObject)docsJson.get(i);
                    String versionString = (String)docJson.get("latestVersion");
                    Version tmpVersion = Version.parseVersion((String)versionString);
                    if (tmpVersion.compareTo(maxVersion) > 0 || maxVersion == null) {
                        maxVersion = tmpVersion;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Failed to get latest JSF archtype version", e);
        }
        return maxVersion;
    }

    private ArchetypeManager getArchetyper() {
        return MavenPluginActivator.getDefault().getArchetypeManager().getArchetyper();
    }

    @Override
    public <T> List<T> getData(String key, Class<T> type, Object ... params) {
        if ("archetypeGAV".equals(key) && type.equals(String.class) && params.length == 1) {
            ArrayList<T> retval = new ArrayList<T>();
            String templateName = params[0].toString();
            Version latestVersion = this.extractLatestVersion("com.liferay.faces.archetype." + templateName + ".portlet:");
            String gav = "com.liferay.faces.archetype:com.liferay.faces.archetype." + templateName + ".portlet:" + latestVersion.toString();
            retval.add(type.cast(gav));
            return retval;
        }
        return super.getData(key, type, params);
    }

    public String getHttpResponse(String request) {
        StringBuilder retVal = new StringBuilder();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(request);
            System.out.println("executing request " + httpget.getURI());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                return response.getStatusLine().getReasonPhrase();
            }
            HttpEntity entity = response.getEntity();
            String body = CoreUtil.readStreamToString((InputStream)entity.getContent(), (boolean)false);
            EntityUtils.consume((HttpEntity)entity);
            retVal.append(body);
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Failed to http response from maven central", e);
        }
        return retVal.toString();
    }

    private Object getJSONResponse(String response) {
        JSONObject retval = null;
        try {
            retval = new JSONObject(response);
        }
        catch (JSONException e) {
            try {
                retval = new JSONArray(response);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return retval;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval = Status.OK_STATUS;
        Path currentProjectLocation = PathBridge.create((IPath)path);
        boolean isLiferayWorkspace = false;
        if (currentProjectLocation != null) {
            isLiferayWorkspace = LiferayWorkspaceUtil.isValidWorkspaceLocation((String)currentProjectLocation.toOSString());
        }
        if (LiferayWorkspaceUtil.isValidWorkspaceLocation((String)currentProjectLocation.toOSString())) {
            retval = LiferayMavenCore.createErrorStatus("Can't set WorkspaceProject root folder as project directory.");
        }
        if (isLiferayWorkspace) {
            File workspaceDir = LiferayWorkspaceUtil.getWorkspaceDir((File)currentProjectLocation.toFile());
            if (workspaceDir == null || !workspaceDir.exists()) {
                return LiferayCore.createErrorStatus((String)"The project location of Liferay Workspace shoule be existed.");
            }
            String[] folders = LiferayWorkspaceUtil.getLiferayWorkspaceProjectWarsDirs((String)workspaceDir.getAbsolutePath());
            if (folders != null) {
                boolean appendWarFolder = false;
                IPath projectLocation = PathBridge.create((Path)currentProjectLocation);
                String[] stringArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    String folder = stringArray[n2];
                    if (projectLocation.lastSegment().endsWith(folder)) {
                        appendWarFolder = true;
                        break;
                    }
                    ++n2;
                }
                if (!appendWarFolder) {
                    return LiferayMavenCore.createErrorStatus("The project location should be wars folder of Liferay workspace.");
                }
            } else {
                return LiferayMavenCore.createErrorStatus("The Liferay Workspace wasn't defined wars folder path.");
            }
        }
        return retval;
    }
}

