/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.server.tomcat.core.internal.MimeMapping;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class MimeMappingDialog
extends Dialog {
    protected MimeMapping map;
    protected boolean isEdit;

    public MimeMappingDialog(Shell parentShell) {
        this(parentShell, new MimeMapping("", ""));
        this.isEdit = false;
    }

    public MimeMappingDialog(Shell parentShell, MimeMapping map) {
        super(parentShell);
        this.map = map;
        this.isEdit = true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(TomcatUIPlugin.getImage("mimeMapping"));
        if (this.isEdit) {
            newShell.setText(Messages.configurationEditorMimeMapppingDialogTitleEdit);
        } else {
            newShell.setText(Messages.configurationEditorMimeMapppingDialogTitleAdd);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.tdmm0000");
        new Label(composite, 0).setText(Messages.configurationEditorMimeMapppingDialogMimeType);
        final Text type = new Text(composite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        type.setLayoutData((Object)data);
        type.setText(this.map.getMimeType());
        type.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MimeMappingDialog.this.map = new MimeMapping(MimeMappingDialog.this.map.getExtension(), type.getText());
                MimeMappingDialog.this.validate();
            }
        });
        whs.setHelp((Control)type, "org.eclipse.jst.server.tomcat.ui.tdmm0002");
        new Label(composite, 0).setText(Messages.configurationEditorMimeMapppingDialogMimeExtension);
        final Text extension = new Text(composite, 2048);
        data = new GridData();
        data.widthHint = 150;
        extension.setLayoutData((Object)data);
        extension.setText(this.map.getExtension());
        extension.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MimeMappingDialog.this.map = new MimeMapping(extension.getText(), MimeMappingDialog.this.map.getMimeType());
                MimeMappingDialog.this.validate();
            }
        });
        whs.setHelp((Control)extension, "org.eclipse.jst.server.tomcat.ui.tdmm0004");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.validate();
        return control;
    }

    protected void validate() {
        boolean ok = true;
        if (this.map.getExtension() == null || this.map.getExtension().length() < 1) {
            ok = false;
        }
        if (this.map.getMimeType() == null || this.map.getMimeType().length() < 1) {
            ok = false;
        }
        this.getButton(0).setEnabled(ok);
    }

    public MimeMapping getMimeMapping() {
        return this.map;
    }
}

