/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.queryspecifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.internal.queryspecifications.ExecutableXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.IExecutableXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;

public class XMLQuerySpecificationRegistry
implements IXMLQuerySpecificationRegistry {
    private final Map<IResource, Collection<IExecutableXMLQuerySpecification>> querySpecificationsMap;
    private final Collection<String> queries;
    private final IContainer container;
    private final IFile file;
    private final Object selectedNode;

    public XMLQuerySpecificationRegistry(IResource resource, Object selectedNode) {
        if (resource.getType() == 1) {
            this.file = (IFile)resource;
            this.container = null;
        } else {
            this.file = null;
            this.container = (IContainer)resource;
        }
        this.selectedNode = selectedNode;
        this.querySpecificationsMap = new HashMap<IResource, Collection<IExecutableXMLQuerySpecification>>();
        this.queries = new ArrayList<String>();
    }

    @Override
    public void register(IXMLQuerySpecification querySpecification, String query, Namespaces namespaceInfos) {
        if (querySpecification.isMultiResource() && this.file != null) {
            IResource[] containers;
            IResource[] iResourceArray = containers = querySpecification.getResources(this.selectedNode, (IResource)this.file);
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IResource container = iResourceArray[n2];
                this.register(querySpecification, query, container, namespaceInfos);
                ++n2;
            }
        } else {
            IContainer container;
            Object object = container = this.file != null ? querySpecification.getResource(this.selectedNode, (IResource)this.file) : this.container;
            if (container == null) {
                return;
            }
            this.register(querySpecification, query, (IResource)container, namespaceInfos);
        }
    }

    @Override
    public void register(IXMLQuerySpecification querySpecification, String query, IResource container, Namespaces namespaceInfos) {
        Collection<IExecutableXMLQuerySpecification> querySpecifications = this.querySpecificationsMap.get(container);
        if (querySpecifications == null) {
            querySpecifications = new ArrayList<IExecutableXMLQuerySpecification>();
            this.querySpecificationsMap.put(container, querySpecifications);
        }
        if (!this.hasQuery(querySpecifications, query)) {
            this.queries.add(query);
            querySpecifications.add(new ExecutableXMLQuerySpecification(this, querySpecification, query, namespaceInfos));
        }
    }

    private boolean hasQuery(Collection<IExecutableXMLQuerySpecification> querySpecifications, String query) {
        for (IExecutableXMLQuerySpecification querySpecification : querySpecifications) {
            if (!querySpecification.getQuery().equals(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<IResource, Collection<IExecutableXMLQuerySpecification>> getQuerySpecificationsMap() {
        return this.querySpecificationsMap;
    }

    @Override
    public Object getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public Collection<String> getQueries() {
        return this.queries;
    }

    @Override
    public String getQueriesLabel() {
        ArrayList<String> cache = new ArrayList<String>();
        StringBuilder label = new StringBuilder();
        int i = 0;
        for (String query : this.queries) {
            if (cache.contains(query)) continue;
            if (i > 0) {
                label.append(", ");
            }
            label.append(query);
            ++i;
            cache.add(query);
        }
        return label.toString();
    }
}

