/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.resource.IResourceCollector;
import org.eclipse.wst.xml.search.core.resource.IResourceRequestor;
import org.eclipse.wst.xml.search.core.resource.IResourceSearchEngine;
import org.eclipse.wst.xml.search.core.resource.IURIResolver;

public class ResourceSearchEngine
implements IResourceSearchEngine {
    private static final IResourceSearchEngine INSTANCE = new ResourceSearchEngine();

    public static IResourceSearchEngine getDefault() {
        return INSTANCE;
    }

    @Override
    public IStatus search(Object selectedNode, IResource[] containers, IResourceRequestor requestor, IResourceCollector collector, IURIResolver resolver, String matching, boolean fullMatch, IProgressMonitor monitor) {
        int i = 0;
        while (i < containers.length) {
            IResource resource = containers[i];
            this.internalSearch(selectedNode, resource, containers[i], requestor, collector, resolver, matching, fullMatch, monitor);
            ++i;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus search(Object selectedNode, IResource container, IResourceRequestor requestor, IResourceCollector collector, IURIResolver resolver, String matching, boolean fullMatch, IProgressMonitor monitor) {
        this.internalSearch(selectedNode, container, container, requestor, collector, resolver, matching, fullMatch, monitor);
        return Status.OK_STATUS;
    }

    private void internalSearch(Object selectedNode, IResource rootContainer, IResource container, IResourceRequestor requestor, IResourceCollector collector, IURIResolver resolver, String matching, boolean fullMatch, IProgressMonitor monitor) {
        if (!requestor.accept(selectedNode, rootContainer, container, resolver, matching, fullMatch)) {
            return;
        }
        int resourceType = container.getType();
        switch (resourceType) {
            case 1: {
                if (!requestor.acceptFile()) break;
                collector.add(container, rootContainer, resolver);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                try {
                    if (requestor.acceptContainer()) {
                        if (!fullMatch) {
                            if (resolver.resolve(selectedNode, rootContainer, container).toUpperCase().startsWith(matching.toUpperCase())) {
                                collector.add(container, rootContainer, resolver);
                            }
                        } else if (resolver.resolve(selectedNode, rootContainer, container).equals(matching)) {
                            collector.add(container, rootContainer, resolver);
                        }
                    }
                    this.internalSearch(selectedNode, rootContainer, ((IContainer)container).members(), requestor, collector, resolver, matching, fullMatch, monitor);
                    break;
                }
                catch (CoreException e) {
                    Trace.trace((byte)3, e.getMessage(), e);
                }
            }
        }
    }

    private IStatus internalSearch(Object selectedNode, IResource rootContainer, IResource[] containers, IResourceRequestor requestor, IResourceCollector collector, IURIResolver resolver, String matching, boolean fullMatch, IProgressMonitor monitor) {
        int i = 0;
        while (i < containers.length) {
            this.internalSearch(selectedNode, rootContainer, containers[i], requestor, collector, resolver, matching, fullMatch, monitor);
            ++i;
        }
        return Status.OK_STATUS;
    }
}

