/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.statics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.search.core.statics.IStaticValue;
import org.eclipse.wst.xml.search.core.statics.IStaticValueCollector;
import org.eclipse.wst.xml.search.core.statics.IStaticValueVisitor;
import org.eclipse.wst.xml.search.core.statics.StaticValue;

public class DefaultStaticValueVisitor
implements IStaticValueVisitor {
    private Map<String, IStaticValue> values = new HashMap<String, IStaticValue>();

    public void registerValue(String key, String description) {
        this.registerValue(new StaticValue(key, description));
    }

    public void registerValue(IStaticValue staticValue) {
        this.values.put(staticValue.getKey(), staticValue);
    }

    public void clearValues() {
        this.values.clear();
    }

    @Override
    public void visit(Object selectedNode, IFile file, String matching, boolean startsWith, IStaticValueCollector collector) {
        if (startsWith) {
            Set<Map.Entry<String, IStaticValue>> entries = this.values.entrySet();
            for (Map.Entry<String, IStaticValue> entry : entries) {
                if (!entry.getKey().startsWith(matching)) continue;
                collector.add(entry.getValue());
            }
        } else {
            IStaticValue value = this.values.get(matching);
            if (value != null) {
                collector.add(value);
            }
        }
    }
}

