/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.xpath;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.internal.XMLSearchCorePlugin;
import org.eclipse.wst.xml.search.core.internal.xpath.XPathProcessorType;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessor;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessorType;

public class XPathProcessorManager
extends AbstractRegistryManager {
    private static final XPathProcessorManager INSTANCE = new XPathProcessorManager();
    private static final String XPATH_EVALUATORS_EXTENSION_POINT = "xpathProcessors";
    private Map<String, IXPathProcessorType> processorsById = null;
    private static final String PROCESSOR_ELT = "processor";
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";
    private IXPathProcessorType processorType;

    public static XPathProcessorManager getDefault() {
        return INSTANCE;
    }

    @Override
    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.processorsById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addProcessors(this.processorsById, cf);
        }
    }

    private synchronized void addProcessors(Map<String, IXPathProcessorType> processorsById, IConfigurationElement[] cf) {
        String id = null;
        String name = null;
        String source = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            source = ce.getContributor().getName();
            if (PROCESSOR_ELT.equals(ce.getName())) {
                try {
                    id = ce.getAttribute(ID_ATTR);
                    name = ce.getAttribute(NAME_ATTR);
                    IXPathProcessor processor = (IXPathProcessor)ce.createExecutableExtension(CLASS_ATTR);
                    processorsById.put(id, new XPathProcessorType(id, name, source, true, processor));
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load XPath processor for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IXPathProcessorType getProcessor(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        if (this.processorsById == null) {
            this.loadProcessors();
        }
        return this.processorsById.get(id);
    }

    private synchronized void loadProcessors() {
        if (this.processorsById != null) {
            return;
        }
        HashMap<String, IXPathProcessorType> processorsById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor(this.getPluginId(), this.getExtensionPoint());
            processorsById = new HashMap(cf.length);
            this.addProcessors(processorsById, cf);
        } else {
            processorsById = new HashMap<String, IXPathProcessorType>();
        }
        this.processorsById = processorsById;
        super.addRegistryListenerIfNeeded();
    }

    @Override
    protected String getExtensionPoint() {
        return XPATH_EVALUATORS_EXTENSION_POINT;
    }

    @Override
    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.core";
    }

    public IXPathProcessorType[] getProcessors() {
        if (this.processorsById == null) {
            this.loadProcessors();
        }
        return this.processorsById.values().toArray(IXPathProcessorType.EMPTY);
    }

    public void setDefaultProcessor(IXPathProcessorType processorType) {
        this.processorType = processorType;
        if (processorType == null) {
            XMLSearchCorePlugin.getDefault().getPluginPreferences().setValue("defaultXPathProcessor", "");
        } else {
            XMLSearchCorePlugin.getDefault().getPluginPreferences().setValue("defaultXPathProcessor", processorType.getId());
        }
        XMLSearchCorePlugin.getDefault().savePluginPreferences();
    }

    public IXPathProcessorType getDefaultProcessor() {
        if (this.processorType == null) {
            String id = XMLSearchCorePlugin.getDefault().getPluginPreferences().getString("defaultXPathProcessor");
            this.processorType = this.getProcessor(id);
        }
        return this.processorType;
    }
}

