/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.xpath.matcher;

import java.util.Collection;
import org.eclipse.wst.xml.search.core.xpath.matcher.AbstractXPathNodeMatcher;
import org.eclipse.wst.xml.search.core.xpath.matcher.IXPathNodeMatcher;
import org.eclipse.wst.xml.search.core.xpath.matcher.XPathMatcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathAttributeMatcher
extends AbstractXPathNodeMatcher {
    private final String attrName;
    private final String attrValue;
    private int indexWildcard = -1;

    public XPathAttributeMatcher(String attrName, String attrValue, XPathMatcher matcher) {
        super(matcher);
        this.attrName = attrName;
        this.attrValue = attrValue;
        if (attrValue.startsWith("$")) {
            try {
                this.indexWildcard = Integer.parseInt(attrValue.substring(1, attrValue.length()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public IXPathNodeMatcher.MatcherType getType() {
        return IXPathNodeMatcher.MatcherType.ATTRIBUTE;
    }

    @Override
    public boolean match(Node testNode, Collection<String> wildcardValues) {
        if (testNode.getNodeType() == 1) {
            Element element = (Element)testNode;
            if (this.indexWildcard != -1) {
                if (element.hasAttribute(this.attrName)) {
                    if (wildcardValues != null) {
                        wildcardValues.add(element.getAttribute(this.attrName));
                    }
                    return true;
                }
                return false;
            }
            String testAttrValue = element.getAttribute(this.attrName);
            return this.attrValue.equals(testAttrValue);
        }
        return false;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public String getAttrValue() {
        return this.attrValue;
    }

    public boolean hasWildcard() {
        return this.indexWildcard != -1;
    }

    public int getIndexWildcard() {
        return this.indexWildcard;
    }

    @Override
    public boolean isAny() {
        return false;
    }
}

