/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSClassTraverser;
import org.eclipse.wst.css.core.internal.util.ImportRuleCollector;
import org.eclipse.wst.html.core.internal.htmlcss.AbstractStyleSheetAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.CSSQueryTraverser;
import org.eclipse.wst.html.core.internal.htmlcss.LinkElementAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.StyleElementAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.StyleListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class HTMLDocumentAdapter
implements IStyleSheetListAdapter,
StyleSheetList {
    private Document document = null;
    private Vector styleAdapters = null;
    private Vector oldStyleAdapters = null;

    HTMLDocumentAdapter() {
    }

    private void addStyleSheet(Element node) {
        IDOMElement element = (IDOMElement)node;
        String tagName = element.getTagName();
        if (tagName == null) {
            return;
        }
        boolean isContainer = false;
        if (tagName.equalsIgnoreCase("HTML") || tagName.equalsIgnoreCase("HEAD") || tagName.equalsIgnoreCase("NOSCRIPT") || tagName.equalsIgnoreCase("BASE") || tagName.equalsIgnoreCase("jsp:root") || !element.isGlobalTag() && element.isContainer()) {
            isContainer = true;
        } else if (element.isCommentTag()) {
            Node parent = element.getParentNode();
            if (parent == element.getOwnerDocument()) {
                isContainer = true;
            } else if (parent.getNodeType() == 1 && (tagName = ((Element)parent).getTagName()) != null && tagName.equalsIgnoreCase("HEAD")) {
                isContainer = true;
            }
        } else {
            String localName = element.getLocalName();
            if (localName != null && localName.equalsIgnoreCase("HTML")) {
                isContainer = true;
            } else {
                IDOMElement notifier = element;
                INodeAdapter adapter = notifier.getAdapterFor(IStyleSheetAdapter.class);
                if (adapter != null && adapter instanceof IStyleSheetAdapter) {
                    this.styleAdapters.addElement(adapter);
                }
            }
        }
        if (isContainer) {
            IDOMElement notifier = element;
            if (notifier.getExistingAdapter(IStyleSheetListAdapter.class) == null) {
                notifier.addAdapter((INodeAdapter)this);
            }
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    this.addStyleSheet((Element)child);
                }
                child = child.getNextSibling();
            }
        }
    }

    void childReplaced() {
        if (this.styleAdapters == null) {
            return;
        }
        this.oldStyleAdapters = this.styleAdapters;
        this.styleAdapters = null;
        this.notifyStyleSheetsChanged(this.document);
    }

    public Enumeration getClasses() {
        StyleSheetList sheetList = this.getStyleSheets();
        int nSheets = sheetList.getLength();
        final ArrayList classes = new ArrayList();
        CSSClassTraverser traverser = new CSSClassTraverser();
        traverser.setTraverseImported(true);
        int i = 0;
        while (i < nSheets) {
            StyleSheet sheet = sheetList.item(i);
            if (sheet instanceof ICSSNode) {
                traverser.apply((ICSSNode)sheet);
            }
            ++i;
        }
        classes.addAll(traverser.getClassNames());
        return new Enumeration(){
            int i = 0;

            public boolean hasMoreElements() {
                return this.i < classes.size();
            }

            public Object nextElement() {
                return classes.get(this.i++);
            }
        };
    }

    private List getValidAdapters() {
        Vector validAdapters = new Vector();
        if (this.styleAdapters != null) {
            for (Object obj : this.styleAdapters) {
                if (!(obj instanceof AbstractStyleSheetAdapter) || !((AbstractStyleSheetAdapter)obj).isValidAttribute()) continue;
                validAdapters.add(obj);
            }
        }
        return validAdapters;
    }

    public int getLength() {
        return this.getValidAdapters().size();
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String pseudoName) {
        StyleSheetList ssl = this.getStyleSheets();
        int numStyles = ssl.getLength();
        CSSQueryTraverser query = new CSSQueryTraverser();
        query.setTraverseImported(true);
        query.setTraverseImportFirst(true);
        query.setElement(element, pseudoName);
        int i = 0;
        while (i < numStyles) {
            StyleSheet ss = ssl.item(i);
            try {
                query.apply((ICSSNode)ss);
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        return query.getDeclaration();
    }

    public StyleSheetList getStyleSheets() {
        if (this.styleAdapters == null) {
            if (this.document == null) {
                return null;
            }
            this.styleAdapters = new Vector();
            Node child = this.document.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    this.addStyleSheet((Element)child);
                }
                child = child.getNextSibling();
            }
            this.removeOldStyleSheets();
        }
        return this;
    }

    public boolean isAdapterForType(Object type) {
        return type == IStyleSheetListAdapter.class;
    }

    public StyleSheet item(int index) {
        if (this.styleAdapters == null) {
            return null;
        }
        List validAdapters = this.getValidAdapters();
        if (index < 0 || index >= validAdapters.size()) {
            return null;
        }
        StyleSheet sheet = ((IStyleSheetAdapter)validAdapters.get(index)).getSheet();
        if (sheet == null) {
            ICSSModel model = ((AbstractStyleSheetAdapter)validAdapters.get(index)).createModel();
            sheet = model != null ? (StyleSheet)model.getDocument() : null;
        }
        return sheet;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Node node = null;
        switch (eventType) {
            case 2: {
                if (newValue instanceof Node) {
                    node = (Node)newValue;
                    break;
                }
                if (!(changedFeature instanceof Attr)) break;
                node = (Attr)changedFeature;
                break;
            }
            case 3: {
                if (oldValue instanceof Node) {
                    node = (Node)oldValue;
                    break;
                }
                if (!(changedFeature instanceof Attr)) break;
                node = (Attr)changedFeature;
                break;
            }
            case 1: {
                node = (Node)notifier;
                break;
            }
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                IDOMElement element = (IDOMElement)node;
                String tagName = element.getTagName();
                if (tagName == null) {
                    return;
                }
                if (eventType == 1) {
                    if (!tagName.equalsIgnoreCase("BASE")) break;
                    this.refreshAdapters();
                    break;
                }
                if (tagName.equalsIgnoreCase("HTML") || tagName.equalsIgnoreCase("HEAD") || tagName.equalsIgnoreCase("STYLE") || tagName.equalsIgnoreCase("LINK") || tagName.equalsIgnoreCase("NOSCRIPT") || tagName.equalsIgnoreCase("jsp:root") || element.isCommentTag() || !element.isGlobalTag() && element.isContainer()) {
                    this.childReplaced();
                    break;
                }
                if (tagName.equalsIgnoreCase("BASE")) {
                    this.refreshAdapters();
                    break;
                }
                String localName = element.getLocalName();
                if (localName == null || !localName.equalsIgnoreCase("HTML")) break;
                this.childReplaced();
                break;
            }
            case 2: {
                if (!"BASE".equals(((Attr)node).getOwnerElement().getLocalName())) break;
                this.refreshAdapters();
            }
        }
    }

    private void refreshAdapters() {
        for (Object adapter : this.styleAdapters) {
            if (adapter instanceof LinkElementAdapter) {
                ((LinkElementAdapter)adapter).refreshSheet();
                continue;
            }
            if (!(adapter instanceof StyleElementAdapter)) continue;
            ICSSModel model = ((StyleElementAdapter)adapter).getModel();
            ImportRuleCollector trav = new ImportRuleCollector();
            trav.apply(model);
            for (ICSSImportRule rule : trav.getRules()) {
                rule.refreshStyleSheet();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void notifyStyleSheetsChanged(Document target) {
        notifier = (INodeNotifier)target;
        if (notifier == null) {
            return;
        }
        adapters = notifier.getAdapters();
        if (adapters == null) {
            return;
        }
        it = adapters.iterator();
        if (it != null) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            adapter = (INodeAdapter)it.next();
            if (!(adapter instanceof StyleListener)) continue;
            listener = (StyleListener)adapter;
            listener.styleChanged();
lbl14:
            // 3 sources

            ** while (it.hasNext())
        }
lbl15:
        // 1 sources

    }

    private void releaseOldStyleSheets() {
        if (this.oldStyleAdapters == null) {
            return;
        }
        for (IStyleSheetAdapter adapter : this.oldStyleAdapters) {
            if (adapter == null || this.styleAdapters != null && this.styleAdapters.contains(adapter)) continue;
            adapter.released();
        }
        this.oldStyleAdapters = null;
    }

    public void releaseStyleSheets() {
        this.releaseOldStyleSheets();
        if (this.styleAdapters == null) {
            return;
        }
        for (IStyleSheetAdapter adapter : this.styleAdapters) {
            if (adapter == null) continue;
            adapter.released();
        }
        this.styleAdapters = null;
    }

    private void removeOldStyleSheets() {
        if (this.oldStyleAdapters == null) {
            return;
        }
        for (IStyleSheetAdapter adapter : this.oldStyleAdapters) {
            if (adapter == null || this.styleAdapters != null && this.styleAdapters.contains(adapter)) continue;
            adapter.removed();
        }
        this.oldStyleAdapters = null;
    }

    void setDocument(Document document) {
        this.document = document;
    }
}

