/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui;

import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.ui.LiferayUIPlugin;
import com.liferay.ide.ui.WorkspaceHelperMBean;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class WorkspaceHelper
implements WorkspaceHelperMBean {
    @Override
    public String openDir(final String path) {
        File dotProject;
        String retval = null;
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            retval = "Directory doesn't exist or isn't a directory.";
        }
        if ((dotProject = new File(dir, ".project")).exists()) {
            retval = this.importExistingProject(dir);
        } else {
            ILiferayProjectImporter[] iLiferayProjectImporterArray = LiferayCore.getImporters();
            int n = iLiferayProjectImporterArray.length;
            int n2 = 0;
            while (n2 < n) {
                final ILiferayProjectImporter importer = iLiferayProjectImporterArray[n2];
                try {
                    IStatus importStatus = importer.canImport(dir.getCanonicalPath());
                    if (importStatus != null && importStatus.isOK()) {
                        UIUtil.async(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    new ProgressMonitorDialog(UIUtil.getActiveShell()).run(true, true, new IRunnableWithProgress(){

                                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                            try {
                                                importer.importProjects(path, monitor);
                                            }
                                            catch (CoreException e) {
                                                LiferayUIPlugin.logError("Error opening project", (Exception)((Object)e));
                                            }
                                        }
                                    });
                                }
                                catch (InterruptedException | InvocationTargetException exception) {
                                    // empty catch block
                                }
                            }
                        });
                        return retval;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            retval = "Directory must have a .project file to open.";
        }
        return retval;
    }

    private String importExistingProject(File dir) {
        String retval = null;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.loadProjectDescription(new Path(dir.getAbsolutePath()).append(".project"));
            final String name = description.getName();
            final IProject project = workspace.getRoot().getProject(name);
            if (project.exists()) {
                retval = "Project with name " + name + " already exists";
            } else {
                final IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            project.create(description, monitor);
                            project.open(128, monitor);
                            try {
                                project.refreshLocal(2, monitor);
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                            shell.forceActive();
                            shell.forceFocus();
                            PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
                            view.selectAndReveal((Object)project);
                        }
                        catch (CoreException e) {
                            LiferayUIPlugin.logError("Unable to import project " + name, (Exception)((Object)e));
                        }
                    }
                };
                UIUtil.async(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new ProgressMonitorDialog(UIUtil.getActiveShell()).run(true, true, runnable);
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (CoreException e) {
            retval = e.getMessage();
        }
        return retval;
    }
}

