/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.util.EventObject;
import java.util.logging.Level;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.ListenerList;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;

public class ExpressionProxy
implements IProxy {
    private final int proxyID;
    private final int proxyType;
    private ListenerList listenerList;
    private Expression expression;

    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.getExpression().getRegistry();
    }

    public ExpressionProxy(int proxyid, int proxyType, Expression expression) {
        this.proxyID = proxyid;
        this.proxyType = proxyType;
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected final int getProxyType() {
        return this.proxyType;
    }

    public final int getProxyID() {
        return this.proxyID;
    }

    public void addProxyListener(ProxyListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList();
        }
        this.listenerList.add(listener);
    }

    public void removeProxyListener(ProxyListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
        }
    }

    protected final boolean hasListeners() {
        return this.listenerList != null && !this.listenerList.isEmpty();
    }

    protected void dispose() {
        this.listenerList = null;
        this.expression = null;
    }

    protected void fireResolved(IBeanProxy proxy) {
        if (this.hasListeners()) {
            ProxyEvent event = new ProxyEvent(this, proxy);
            Object[] listeners = this.listenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((ProxyListener)listeners[i]).proxyResolved(event);
                }
                catch (RuntimeException e) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                }
                ++i;
            }
        }
        this.dispose();
    }

    protected void fireNotResolved() {
        if (this.hasListeners()) {
            ProxyEvent event = new ProxyEvent(this);
            Object[] listeners = this.listenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((ProxyListener)listeners[i]).proxyNotResolved(event);
                }
                catch (RuntimeException e) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                }
                ++i;
            }
        }
        this.dispose();
    }

    protected void fireVoidResolved() {
        if (this.hasListeners()) {
            ProxyEvent event = new ProxyEvent(this);
            Object[] listeners = this.listenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((ProxyListener)listeners[i]).proxyVoid(event);
                }
                catch (RuntimeException e) {
                    ProxyPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                }
                ++i;
            }
        }
        this.dispose();
    }

    public final boolean isBeanProxy() {
        return false;
    }

    public final boolean isExpressionProxy() {
        return true;
    }

    public boolean isValidForReassignment() {
        return this.getProxyType() == 0;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.getProxyID();
    }

    public static class ProxyAdapter
    implements ProxyListener {
        public void proxyNotResolved(ProxyEvent event) {
        }

        public void proxyResolved(ProxyEvent event) {
        }

        public void proxyVoid(ProxyEvent event) {
        }
    }

    public static class ProxyEvent
    extends EventObject {
        private static final long serialVersionUID = -2305781662465107377L;
        private final IBeanProxy proxy;

        public ProxyEvent(ExpressionProxy source, IBeanProxy proxy) {
            super(source);
            this.proxy = proxy;
        }

        public ProxyEvent(ExpressionProxy source) {
            this(source, null);
        }

        public IBeanProxy getProxy() {
            return this.proxy;
        }
    }

    public static interface ProxyListener {
        public void proxyResolved(ProxyEvent var1);

        public void proxyNotResolved(ProxyEvent var1);

        public void proxyVoid(ProxyEvent var1);
    }
}

