/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.searcher;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.xml.search.ui.PortalLanguagePropertiesCacheUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToProperty;
import org.eclipse.wst.xml.search.editor.searchers.properties.XMLSearcherForProperties;

public class LiferayJspLanguagePropertiesSearcher
extends XMLSearcherForProperties {
    private static final String HOVER = "\"{0}\" in {1}";

    public String searchForTextHover(Object selectedNode, int offset, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        StringBuffer sb = new StringBuffer();
        if (referenceTo instanceof IXMLReferenceToProperty) {
            Object key;
            Properties portalProperties;
            IProject project = file.getProject();
            List languageFiles = PropertiesUtil.getDefaultLanguagePropertiesFromProject((IProject)project);
            for (IFile languageFile : languageFiles) {
                Properties properties = new Properties();
                InputStream contents = null;
                try {
                    contents = languageFile.getContents();
                    properties.load(contents);
                    Object key2 = properties.get(mathingString);
                    if (key2 == null) continue;
                    sb.append(NLS.bind((String)HOVER, (Object)key2, (Object)languageFile.getFullPath().toString())).append("<br/>");
                }
                catch (Exception exception) {
                }
                finally {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (CoreUtil.isNullOrEmpty((String)sb.toString()) && (portalProperties = PortalLanguagePropertiesCacheUtil.getPortalLanguageProperties(LiferayCore.create((Object)project))) != null && (key = portalProperties.get(mathingString)) != null) {
                sb.append(NLS.bind((String)HOVER, (Object)key, (Object)"Liferay Portal Language.properties"));
            }
        }
        return sb.toString();
    }
}

