/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.util.HttpClientTransportService;
import org.eclipse.mylyn.internal.discovery.core.util.IOWithCauseException;
import org.eclipse.mylyn.internal.discovery.core.util.ITransportService;
import org.eclipse.mylyn.internal.discovery.core.util.P2TransportService;

public class WebUtil {
    private static ITransportService transport;

    public static IStatus download(URI uri, File target, IProgressMonitor monitor) throws IOException {
        IStatus result;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));){
            result = WebUtil.download(uri, out, monitor);
        }
        if (!result.isOK()) {
            target.delete();
            if (result.getException() instanceof IOException) {
                throw (IOException)result.getException();
            }
            throw new IOWithCauseException(result.getException());
        }
        return result;
    }

    public static void readResource(URI uri, TextContentProcessor processor, IProgressMonitor monitor) throws IOException, CoreException {
        try (InputStream in = WebUtil.stream(uri, monitor);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            processor.process(reader);
        }
    }

    public static boolean verifyAvailability(List<? extends URI> locations, boolean one, IProgressMonitor monitor) {
        if (locations.isEmpty() || locations.size() > 5) {
            throw new IllegalArgumentException();
        }
        int countFound = 0;
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.discovery.core", 0, "Verifying resource availability failed", (Throwable)new Exception());
        try {
            for (URI uRI : locations) {
                block12: {
                    WebUtil.getLastModified(uRI, monitor);
                    if (!one) break block12;
                    return true;
                }
                try {
                    ++countFound;
                }
                catch (IOException | CoreException e) {
                    status.add(WebUtil.getStatus((Exception)e));
                    if (one) continue;
                    if (!status.isOK()) {
                        StatusHandler.log((IStatus)status);
                    }
                    return false;
                }
            }
        }
        finally {
            if (!status.isOK()) {
                StatusHandler.log((IStatus)status);
            }
        }
        return countFound == locations.size();
    }

    private static IStatus getStatus(Exception e) {
        if (e instanceof CoreException) {
            return ((CoreException)((Object)e)).getStatus();
        }
        return new Status(4, "org.eclipse.mylyn.discovery.core", e.getMessage(), (Throwable)e);
    }

    public static synchronized ITransportService getTransport() {
        if (transport == null) {
            if (Platform.isRunning()) {
                try {
                    transport = new P2TransportService();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (transport == null) {
                transport = new HttpClientTransportService();
            }
        }
        return transport;
    }

    public static IStatus download(URI uri, OutputStream out, IProgressMonitor monitor) {
        return WebUtil.getTransport().download(uri, out, monitor);
    }

    public static InputStream stream(URI uri, IProgressMonitor monitor) throws IOException, CoreException {
        return WebUtil.getTransport().stream(uri, monitor);
    }

    private static long getLastModified(URI location, IProgressMonitor monitor) throws CoreException, IOException {
        return WebUtil.getTransport().getLastModified(location, monitor);
    }

    public static String getFileNameFor(String bundleUrl) throws IOException {
        if (bundleUrl.charAt(bundleUrl.length() - 1) == '/') {
            bundleUrl = bundleUrl.substring(0, bundleUrl.length() - 1);
        }
        if (bundleUrl.lastIndexOf(47) != -1) {
            bundleUrl = bundleUrl.substring(bundleUrl.lastIndexOf(47) + 1);
        }
        return bundleUrl.replaceAll("[^a-zA-Z0-9_\\.]", "_");
    }

    public static interface TextContentProcessor {
        public void process(Reader var1) throws IOException;
    }
}

