/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.model.Node;
import com.liferay.ide.kaleo.ui.IKaleoEditorHelper;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.editor.HiddenFileEditorInput;
import com.liferay.ide.kaleo.ui.editor.ScriptPropertyEditorInput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractKaleoEditorHelper
implements IKaleoEditorHelper {
    private String contributorName;
    private String editorId;
    private String fileExtension;
    private String languageType;

    @Override
    public IEditorPart createEditorPart(ScriptPropertyEditorInput editorInput, IEditorSite editorSite) {
        TextEditor editorPart = null;
        try {
            editorPart = new TextEditor();
            editorPart.init(editorSite, (IEditorInput)editorInput);
        }
        catch (PartInitException e) {
            KaleoUI.logError("Could not create default script editor.", (Exception)((Object)e));
        }
        return editorPart;
    }

    @Override
    public String getContributorName() {
        return this.contributorName;
    }

    @Override
    public String getEditorId() {
        return this.editorId;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    private HiddenFileEditorInput getHiddenFileEditorInput(IProject project, String name, String nodeName, String fileContents) {
        return new HiddenFileEditorInput(this.getTemporaryFile(project, name, nodeName, this.getFileExtension(), fileContents));
    }

    @Override
    public String getLanguageType() {
        return this.languageType;
    }

    private IFile getTemporaryFile(IProject project, String name, String nodeName, String fileExtension, String fileContents) {
        if (CoreUtil.empty((String)fileContents)) {
            fileContents = "";
        }
        IPath tempScriptFilePath = this.getTempScriptFilePath(project, name, nodeName, fileExtension);
        IFile tempFile = ResourcesPlugin.getWorkspace().getRoot().getFile(tempScriptFilePath);
        try {
            ByteArrayInputStream source = new ByteArrayInputStream(fileContents.getBytes("UTF-8"));
            if (tempFile.exists()) {
                tempFile.setContents((InputStream)source, true, false, null);
            } else {
                tempFile.create((InputStream)source, true, null);
            }
        }
        catch (UnsupportedEncodingException | CoreException e) {
            e.printStackTrace();
        }
        return tempFile;
    }

    private String getTempScriptFileName(String name, String nodeName, String fileExtension) {
        StringBuilder retval = new StringBuilder();
        if (!CoreUtil.empty((String)nodeName)) {
            retval.append(nodeName.replaceAll("![A-Za-z]+", "").replaceAll("\\s+", ""));
        } else if (!CoreUtil.empty((String)name)) {
            retval.append(name.replaceAll("![A-Za-z]+", ""));
        }
        retval.append(".").append(fileExtension);
        return retval.toString();
    }

    private IPath getTempScriptFilePath(IProject project, String name, String nodeName, String fileExtension) {
        IPath retval = null;
        Object folder = null;
        Path tempPath = new Path("._KALEO_TEMP_SCRIPT_" + System.currentTimeMillis() + "/" + this.getTempScriptFileName(name, nodeName, fileExtension));
        if (project != null && tempPath != null) {
            Object[] folders = CoreUtil.getSourceFolders((IJavaProject)JavaCore.create((IProject)project)).toArray(new IFolder[0]);
            folder = !CoreUtil.empty((Object[])folders) ? folders[0] : project;
        }
        if (folder != null) {
            IFile tempFile = folder.getFile((IPath)tempPath);
            try {
                CoreUtil.makeFolders((IFolder)((IFolder)tempFile.getParent()));
                retval = tempFile.getFullPath();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    public void handleDropFromPalette(IEditorPart activeEditor) {
    }

    @Override
    public void openEditor(ISapphirePart sapphirePart, final Element modelElement, final ValueProperty valueProperty) {
        try {
            Object content = modelElement.property(valueProperty).content();
            if (content == null) {
                content = "";
            }
            IProject project = (IProject)sapphirePart.adapt(IProject.class);
            IEditorInput editorInput = (IEditorInput)modelElement.adapt(IEditorInput.class);
            String name = editorInput.getName();
            String nodeName = (String)((Node)modelElement.nearest(Node.class)).getName().content();
            final HiddenFileEditorInput hiddenFileEditorInput = this.getHiddenFileEditorInput(project, name, nodeName, content.toString());
            IEditorSite editorSite = (IEditorSite)sapphirePart.adapt(IEditorSite.class);
            final IEditorPart editorPart = editorSite.getWorkbenchWindow().getActivePage().openEditor((IEditorInput)hiddenFileEditorInput, this.editorId);
            ITextEditor textEditor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
            textEditor.getDocumentProvider().getDocument((Object)hiddenFileEditorInput).addDocumentListener(new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    String contents = event.getDocument().get();
                    modelElement.property(valueProperty).write((Object)contents);
                }
            });
            editorPart.getSite().getPage().addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    if (part != null && part.equals(editorPart)) {
                        new WorkspaceJob("delete temp editor file"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                try {
                                    hiddenFileEditorInput.getFile().getParent().delete(true, null);
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule(100L);
                    }
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            });
        }
        catch (Exception e) {
            KaleoUI.logError("Error opening editor.", e);
        }
    }

    public void setContributorName(String contributorName) {
        this.contributorName = contributorName;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setLanguageType(String langauge) {
        this.languageType = langauge;
    }
}

