/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.navigator;

import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.action.EditWorkflowDefinitionAction;
import com.liferay.ide.kaleo.ui.action.PublishWorkflowDefinitionAction;
import com.liferay.ide.kaleo.ui.action.RefreshWorkflowDefinitionsAction;
import com.liferay.ide.kaleo.ui.action.UploadNewWorkflowDefinitionAction;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionsFolder;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class WorkflowDefinitionsActionProvider
extends CommonActionProvider {
    public static final String NEW_MENU_ID = "org.eclipse.wst.server.ui.internal.cnf.newMenuId";
    public static final String TOP_SECTION_END_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.topSectionEnd";
    public static final String TOP_SECTION_START_SEPARATOR = "org.eclipse.wst.server.ui.internal.cnf.topSectionStart";
    private ICommonActionExtensionSite actionSite;
    private EditWorkflowDefinitionAction editAction;
    private PublishWorkflowDefinitionAction publishAction;
    private RefreshWorkflowDefinitionsAction refreshAction;
    private UploadNewWorkflowDefinitionAction uploadAction;

    private void addListeners(CommonViewer tableViewer) {
        tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    Object data = sel.getFirstElement();
                    if (!(data instanceof WorkflowDefinitionEntry)) {
                        return;
                    }
                    WorkflowDefinitionsActionProvider.this.editAction.run();
                }
                catch (Exception e) {
                    KaleoUI.logError("Error opening kaleo workflow.", e);
                }
            }
        });
    }

    protected void addTopSection(IMenuManager menu, WorkflowDefinitionEntry definition, WorkflowDefinitionsFolder definitionsFolder) {
        if (definition != null) {
            menu.add((IAction)this.editAction);
            menu.add((IAction)this.publishAction);
        }
        if (definitionsFolder != null) {
            menu.add((IAction)this.refreshAction);
            menu.add((IAction)this.uploadAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.removeAll();
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        WorkflowDefinitionEntry definition = null;
        WorkflowDefinitionsFolder definitionsFolder = null;
        if (selection != null && !selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            Object obj = iterator.next();
            if (obj instanceof WorkflowDefinitionEntry) {
                definition = (WorkflowDefinitionEntry)obj;
            }
            if (obj instanceof WorkflowDefinitionsFolder) {
                definitionsFolder = (WorkflowDefinitionsFolder)obj;
            }
            if (iterator.hasNext()) {
                definition = null;
                definitionsFolder = null;
            }
        }
        menu.add((IContributionItem)this.invisibleSeparator(TOP_SECTION_START_SEPARATOR));
        this.addTopSection(menu, definition, definitionsFolder);
        menu.add((IContributionItem)this.invisibleSeparator(TOP_SECTION_END_SEPARATOR));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void init(ICommonActionExtensionSite site) {
        StructuredViewer v;
        super.init(site);
        this.actionSite = site;
        ICommonViewerSite viewerSite = site.getViewSite();
        if (viewerSite instanceof ICommonViewerWorkbenchSite && (v = site.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)viewerSite;
            this.addListeners(cv);
            this.makeActions(cv, wsSite.getSelectionProvider());
        }
    }

    private Separator invisibleSeparator(String s) {
        Separator sep = new Separator(s);
        sep.setVisible(false);
        return sep;
    }

    private void makeActions(CommonViewer tableViewer, ISelectionProvider provider) {
        this.editAction = new EditWorkflowDefinitionAction(provider);
        this.refreshAction = new RefreshWorkflowDefinitionsAction(provider);
        this.publishAction = new PublishWorkflowDefinitionAction(provider);
        this.uploadAction = new UploadNewWorkflowDefinitionAction(provider);
    }
}

