/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.util.KaleoUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.json.JSONArray;
import org.json.JSONObject;

public class UploadWorkflowFileJob
extends Job {
    private IKaleoConnection kaleoConnection;
    private IFile workflowFile;
    private Runnable runnable;

    public UploadWorkflowFileJob(IKaleoConnection kaleoConnection, IFile workflowFile, Runnable runnable) {
        super("Uploading new workflow draft definition");
        this.kaleoConnection = kaleoConnection;
        this.workflowFile = workflowFile;
        this.runnable = runnable;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            final String errorMsgs = KaleoUtil.checkWorkflowDefinitionForErrors(this.workflowFile);
            if (!CoreUtil.empty((String)errorMsgs)) {
                UIUtil.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Upload Kaleo Workflow", (String)("Unable to upload kaleo workflow:\n\n" + errorMsgs));
                    }
                });
                return Status.OK_STATUS;
            }
            JSONObject def = this.kaleoConnection.getKaleoDefinitions().getJSONObject(0);
            int companyId = def.getInt("companyId");
            long groupId = def.getLong("groupId");
            long userId = this.kaleoConnection.getUserByEmailAddress().getLong("userId");
            WorkflowDefinition workflowDefinition = (WorkflowDefinition)WorkflowDefinition.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(this.workflowFile.getContents()))).nearest(WorkflowDefinition.class);
            String portalLocale = "en_US";
            try {
                portalLocale = this.kaleoConnection.getPortalLocale(userId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String name = (String)workflowDefinition.getName().content();
            String titleMap = KaleoUtil.createJSONTitleMap(name, portalLocale);
            String content = CoreUtil.readStreamToString((InputStream)this.workflowFile.getContents());
            JSONArray drafts = this.kaleoConnection.getKaleoDraftWorkflowDefinitions();
            JSONObject existingDraft = null;
            if (drafts != null && drafts.length() > 0) {
                int i = 0;
                while (i < drafts.length()) {
                    JSONObject draft = drafts.getJSONObject(i);
                    String draftName = draft.getString("name");
                    if (name != null && name.equals(draftName)) {
                        if (existingDraft == null) {
                            existingDraft = draft;
                        } else if (draft.getInt("draftVersion") > existingDraft.getInt("draftVersion") || draft.getInt("version") > existingDraft.getInt("version")) {
                            existingDraft = draft;
                        }
                    }
                    ++i;
                }
            }
            if (existingDraft != null) {
                this.kaleoConnection.updateKaleoDraftDefinition(name, titleMap, content, existingDraft.getInt("version"), existingDraft.getInt("draftVersion"), (long)companyId, userId);
            }
            this.kaleoConnection.publishKaleoDraftDefinition(name, titleMap, content, String.valueOf(companyId), String.valueOf(userId), String.valueOf(groupId));
        }
        catch (Exception e) {
            return KaleoUI.createErrorStatus("Error uploading new kaleo workflow file.", e);
        }
        if (this.runnable != null) {
            this.runnable.run();
        }
        return Status.OK_STATUS;
    }
}

