/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.xml;

import com.liferay.ide.kaleo.ui.xml.KaleoEdits;
import com.liferay.ide.kaleo.ui.xml.NodeOperation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtils {
    public static IProject extractProject(ITextViewer sourceViewer) {
        ITextFileBuffer buf = FileBuffers.getTextFileBufferManager().getTextFileBuffer(sourceViewer.getDocument());
        if (buf == null) {
            return null;
        }
        IFileStore folder = buf.getFileStore();
        File file = new File(folder.toURI());
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (ifile != null) {
            return ifile.getProject();
        }
        return null;
    }

    public static Element findChild(Element parent, String name) {
        return KaleoEdits.findChild(parent, name);
    }

    public static Element findChild(Element parent, String name, KaleoEdits.Matcher ... matchers) {
        return KaleoEdits.findChild(parent, name, matchers);
    }

    public static List<Element> findChilds(Element parent, String name) {
        return KaleoEdits.findChilds(parent, name);
    }

    public static String getTextValue(Node element) {
        return KaleoEdits.getTextValue(element);
    }

    public static String pathUp(Node node, int level) {
        StringBuffer buf = new StringBuffer();
        int current = level;
        while (node != null && current > 0) {
            if (node instanceof Element) {
                if (buf.length() > 0) {
                    buf.insert(0, "/");
                }
                buf.insert(0, node.getNodeName());
                --current;
            }
            node = node.getParentNode();
        }
        return buf.toString();
    }

    public static void performOnCurrentElement(IDocument document, int offset, NodeOperation<Node> operation) {
        assert (document != null);
        assert (operation != null);
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null) {
                IndexedRegion inode = sModel.getIndexedRegion(offset);
                if (inode == null) {
                    inode = sModel.getIndexedRegion(offset - 1);
                }
                if (inode instanceof Node) {
                    operation.process((Node)inode, sModel.getStructuredDocument());
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public static void performOnRootElement(IDocument doc, NodeOperation<Element> operation) {
        assert (doc != null);
        assert (operation != null);
        IDOMModel domModel = null;
        try {
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(doc);
            if (domModel == null) {
                throw new IllegalArgumentException("Document is not structured: " + doc);
            }
            IStructuredDocument document = domModel.getStructuredDocument();
            Element root = domModel.getDocument().getDocumentElement();
            operation.process(root, document);
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    public static void performOnRootElement(IFile resource, NodeOperation<Element> operation) throws IOException, CoreException {
        assert (resource != null);
        assert (operation != null);
        IDOMModel domModel = null;
        try {
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(resource);
            if (domModel == null) {
                throw new IllegalArgumentException("Document is not structured: " + resource);
            }
            IStructuredDocument document = domModel.getStructuredDocument();
            Element root = domModel.getDocument().getDocumentElement();
            operation.process(root, document);
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }
}

