/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.handlers;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class SDKCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean isLiferay;
        IEditorInput editorInput;
        IStatus retval = null;
        IProject project = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object selected = structuredSelection.getFirstElement();
            if (selected instanceof IResource) {
                project = ((IResource)selected).getProject();
            } else if (selected instanceof IJavaElement) {
                project = ((IJavaElement)selected).getJavaProject().getProject();
            } else if (selected instanceof PackageFragmentRootContainer) {
                project = ((PackageFragmentRootContainer)selected).getJavaProject().getProject();
            }
        }
        if (project == null && (editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) != null && editorInput.getAdapter(IResource.class) != null) {
            project = ((IResource)editorInput.getAdapter(IResource.class)).getProject();
        }
        if ((isLiferay = CoreUtil.isLiferayProject(project)) && SDKUtil.isSDKProject(project)) {
            retval = this.executeSdkCommand(project);
        }
        return retval;
    }

    protected IStatus executeSdkCommand(IProject project) {
        IStatus retval = null;
        try {
            IFile buildXmlFile = project.getFile("build.xml");
            if (buildXmlFile.exists()) {
                final IProject p = project;
                final IFile buildFile = buildXmlFile;
                new Job(String.valueOf(p.getName()) + " : " + this.getSDKCommand()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            SDK sdk = SDKUtil.getSDK((IProject)p);
                            sdk.runCommand(p, buildFile, SDKCommandHandler.this.getSDKCommand(), null, monitor);
                            p.refreshLocal(2, monitor);
                        }
                        catch (Exception e) {
                            return ProjectUI.createErrorStatus("Error running SDK command " + SDKCommandHandler.this.getSDKCommand(), e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        catch (Exception e) {
            retval = ProjectCore.createErrorStatus((String)"Unable to execute sdk command", (Throwable)e);
        }
        return retval;
    }

    protected abstract String getSDKCommand();
}

