/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.pref;

import aQute.bnd.osgi.Domain;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.BladeCLIException;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Version;

public class BladeCLIPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private final ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.liferay.ide.project.core");

    public BladeCLIPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Group group = SWTUtil.createGroup((Composite)this.getFieldEditorParent(), (String)"", (int)1);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite composite = SWTUtil.createComposite((Composite)group, (int)2, (int)2, (int)1808);
        this.addField((FieldEditor)new StringFieldEditor("BLADE_CLI_REPO_URL", "Blade CLI Repo URL:", composite));
        Label currentVersionLabel = new Label(composite, 0);
        currentVersionLabel.setText("Current Embedded Blade CLI Version:");
        final Text currentBladeVersionText = new Text(composite, 2048);
        currentBladeVersionText.setLayoutData((Object)new GridData(768));
        currentBladeVersionText.setEditable(false);
        try {
            currentBladeVersionText.setText(this.getCurrentBladeVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Label latestVersionLabel = new Label(composite, 0);
        latestVersionLabel.setText("Latest Blade Version:");
        final Text latestBladeVersionText = new Text(composite, 2048);
        latestBladeVersionText.setLayoutData((Object)new GridData(768));
        latestBladeVersionText.setEditable(false);
        latestBladeVersionText.setText("Checking...");
        final Button updateBladeButton = new Button((Composite)group, 8);
        updateBladeButton.setText("Update Embedded Blade to Latest Version");
        updateBladeButton.setEnabled(false);
        final Button restoreBladeJarButton = new Button((Composite)group, 8);
        restoreBladeJarButton.setText("Restore Embedded Blade CLI to Original Version");
        updateBladeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    File newBladeJar = BladeCLI.fetchBladeJarFromRepo();
                    if (newBladeJar != null) {
                        BladeCLI.addToLocalInstance((File)newBladeJar);
                    }
                    currentBladeVersionText.setText(BladeCLIPreferencePage.this.getCurrentBladeVersion());
                    MessageDialog.openInformation((Shell)BladeCLIPreferencePage.this.getShell(), (String)"Blade CLI", (String)"Update successful.");
                    updateBladeButton.setEnabled(false);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)BladeCLIPreferencePage.this.getShell(), (String)"Blade CLI", (String)("Could not update Blade CLI: " + e.getMessage()));
                }
            }
        });
        restoreBladeJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BladeCLI.restoreOriginal();
                try {
                    currentBladeVersionText.setText(BladeCLIPreferencePage.this.getCurrentBladeVersion());
                    restoreBladeJarButton.setEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Job job = new Job("Checking latest blade cli version..."){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    String currentVersion = BladeCLIPreferencePage.this.getCurrentBladeVersion();
                    File updateJar = BladeCLI.fetchBladeJarFromRepo();
                    final String newVersion = Domain.domain((File)updateJar).getBundleVersion();
                    final boolean newAvailable = new Version(newVersion).compareTo(new Version(currentVersion)) > 0;
                    UIUtil.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!latestBladeVersionText.isDisposed() && !updateBladeButton.isDisposed()) {
                                if (newAvailable) {
                                    latestBladeVersionText.setText(newVersion);
                                } else {
                                    latestBladeVersionText.setText("");
                                }
                                updateBladeButton.setEnabled(newAvailable);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private String getCurrentBladeVersion() throws IOException, BladeCLIException {
        return new Version(Domain.domain((File)BladeCLI.getBladeCLIPath().toFile()).getBundleVersion()).toString();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.prefStore;
    }

    public void init(IWorkbench workbench) {
    }
}

