/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.pref;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.TargetPlatformUtil;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TargetPlatformSettingsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PROJECT_UI_TARGETPLATFORM_PAGE_ID = "com.liferay.ide.project.ui.targetPlatformSettingsPage";
    private ComboViewer targetPlatFormVersion;
    private ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.liferay.ide.project.core");

    public void init(IWorkbench workbench) {
    }

    private void initvaules() {
        String version;
        IPreferenceStore store = this.getPreStore();
        if (store != null) {
            version = store.getString("current_targetplatform_version").replace("[", "").replace("]", "");
            if (version == null || version.equals("")) {
                version = "CE-7.0.0-GA2";
            }
        } else {
            version = "CE-7.0.0-GA2";
        }
        StructuredSelection selection = new StructuredSelection((Object)version);
        this.targetPlatFormVersion.setSelection((ISelection)selection);
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        comp.setLayout((Layout)layout);
        new Label(comp, 0).setText("Liferay Target Platform Version:");
        this.targetPlatFormVersion = new ComboViewer(comp, 8);
        this.targetPlatFormVersion.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.targetPlatFormVersion.setContentProvider((IContentProvider)new ArrayContentProvider());
        try {
            this.targetPlatFormVersion.setInput((Object)TargetPlatformUtil.getAllTargetPlatfromVersions());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initvaules();
        return comp;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.storeValues();
        return result;
    }

    private void storeValues() {
        this.preferenceStore.setValue("current_targetplatform_version", this.targetPlatFormVersion.getSelection().toString());
        try {
            this.preferenceStore.save();
        }
        catch (IOException e) {
            ProjectCore.logError((String)"Can not save target platform preference", (Exception)e);
        }
    }

    private IPreferenceStore getPreStore() {
        return this.preferenceStore;
    }
}

