/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.project.ui.upgrade.CopyPortalSettingsHandler;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.DefaultValueService;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.services.ValidationService;

public interface GetPortalSettingsOp
extends ExecutableElement {
    public static final ElementType TYPE = new ElementType(GetPortalSettingsOp.class);
    @AbsolutePath
    @Label(standard="Previous Liferay location")
    @Type(base=org.eclipse.sapphire.modeling.Path.class)
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @Service(impl=PreviousLiferayLocationValidationService.class)
    public static final ValueProperty PROP_PREVIOUS_LIFERAY_LOCATION = new ValueProperty(TYPE, "PreviousLiferayLocation");
    @Service(impl=NewLiferayNameDVS.class)
    @Label(standard="New Liferay name")
    public static final ValueProperty PROP_NEW_LIFERAY_NAME = new ValueProperty(TYPE, "NewLiferayName");
    @AbsolutePath
    @Label(standard="New Liferay location")
    @Type(base=org.eclipse.sapphire.modeling.Path.class)
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @Service(impl=NewLiferayLocationValidationService.class)
    public static final ValueProperty PROP_NEW_LIFERAY_LOCATION = new ValueProperty(TYPE, "NewLiferayLocation");

    public Value<org.eclipse.sapphire.modeling.Path> getPreviousLiferayLocation();

    public void setPreviousLiferayLocation(String var1);

    public void setPreviousLiferayLocation(org.eclipse.sapphire.modeling.Path var1);

    public Value<String> getNewLiferayName();

    public void setNewLiferayName(String var1);

    public Value<org.eclipse.sapphire.modeling.Path> getNewLiferayLocation();

    public void setNewLiferayLocation(String var1);

    public void setNewLiferayLocation(org.eclipse.sapphire.modeling.Path var1);

    @DelegateImplementation(value=CopyPortalSettingsHandler.class)
    public Status execute(ProgressMonitor var1);

    public static class LiferayLocationValidationService
    extends ValidationService {
        private final ValueProperty _prop;
        private final String _version;

        public LiferayLocationValidationService(ValueProperty prop, String version) {
            this._prop = prop;
            this._version = version;
        }

        protected Status compute() {
            String path;
            PortalBundle portalBundle;
            Status retval = Status.createOkStatus();
            org.eclipse.sapphire.modeling.Path liferayLocation = (org.eclipse.sapphire.modeling.Path)this.op().property(this._prop).content();
            if (!(liferayLocation == null || liferayLocation.isEmpty() || (portalBundle = LiferayServerCore.newPortalBundle((IPath)new Path(path = liferayLocation.toOSString()))) != null && portalBundle.getVersion().startsWith(this._version))) {
                retval = Status.createErrorStatus((String)("Invalid Liferay " + this._version + " folder location."));
            }
            return retval;
        }

        private GetPortalSettingsOp op() {
            return (GetPortalSettingsOp)this.context(GetPortalSettingsOp.class);
        }
    }

    public static class NameDVS
    extends DefaultValueService {
        private ValueProperty _prop;

        public NameDVS(ValueProperty prop) {
            this._prop = prop;
        }

        protected void initDefaultValueService() {
            ((GetPortalSettingsOp)this.context(GetPortalSettingsOp.class)).property(this._prop).attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent arg0) {
                    this.refresh();
                }
            });
        }

        protected String compute() {
            org.eclipse.sapphire.modeling.Path path = (org.eclipse.sapphire.modeling.Path)((GetPortalSettingsOp)this.context(GetPortalSettingsOp.class)).property(this._prop).content();
            if (path != null) {
                return path.lastSegment();
            }
            return null;
        }
    }

    public static class NewLiferayLocationValidationService
    extends LiferayLocationValidationService {
        public NewLiferayLocationValidationService() {
            super(PROP_NEW_LIFERAY_LOCATION, "7.0");
        }
    }

    public static class NewLiferayNameDVS
    extends NameDVS {
        public NewLiferayNameDVS() {
            super(PROP_NEW_LIFERAY_LOCATION);
        }
    }

    public static class PreviousLiferayLocationValidationService
    extends LiferayLocationValidationService {
        public PreviousLiferayLocationValidationService() {
            super(PROP_PREVIOUS_LIFERAY_LOCATION, "6.2");
        }
    }
}

