/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade;

import com.liferay.ide.project.ui.ProjectUI;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class LiferayUpgradeCompare {
    private final IPath soruceFile;
    private final IPath targetFile;
    private String fileName;

    public LiferayUpgradeCompare(IPath soruceFile, IPath targetFile, String fileName) {
        this.fileName = fileName;
        this.soruceFile = soruceFile;
        this.targetFile = targetFile;
    }

    protected File getSourceFile() {
        return this.soruceFile.toFile();
    }

    protected File getTargetFile() {
        return this.targetFile.toFile();
    }

    public void openCompareEditor() {
        try {
            final CompareItem left = new CompareItem(this.getSourceFile(), this.fileName);
            final CompareItem right = new CompareItem(this.getTargetFile(), String.valueOf(this.fileName) + "_preview");
            CompareConfiguration configuration = new CompareConfiguration();
            configuration.setLeftLabel("Original File");
            configuration.setRightLabel("Upgraded File");
            CompareEditorInput editorInput = new CompareEditorInput(configuration){

                protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DiffNode diffNode = new DiffNode(left, right);
                    return diffNode;
                }
            };
            editorInput.setTitle("Compare ('" + this.soruceFile.toPortableString() + "'-'" + this.targetFile.toPortableString() + "')");
            CompareUI.openCompareEditor((CompareEditorInput)editorInput);
        }
        catch (Exception e) {
            ProjectUI.logError(e);
        }
    }

    private class CompareItem
    implements ITypedElement,
    IStreamContentAccessor,
    IModificationDate,
    IEditableContent {
        private File file;
        private String name;

        public CompareItem(File file, String name) {
            this.file = file;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public long getModificationDate() {
            return 0L;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new FileInputStream(this.file);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean isEditable() {
            return false;
        }

        public void setContent(byte[] newContent) {
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }
    }
}

