/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.ProjectUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCanvas
extends Canvas {
    private static final int DEFAULT_TIMER_INTERVAL = 10;
    public static final int NONE = -1;
    protected long currentTime = 0L;
    protected Font baseFont;
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            AbstractCanvas.this.doRun();
        }
    };

    public static Rectangle drawText(GC gc, double cX, double cY, String text) {
        return AbstractCanvas.drawText(gc, cX, cY, text, 0);
    }

    public static Rectangle drawText(GC gc, double cX, double cY, String text, int box) {
        Point extent = gc.stringExtent(text);
        int x = (int)(cX - (double)(extent.x / 2));
        int y = (int)(cY - (double)(extent.y / 2));
        if (x < box) {
            x = box;
        }
        Rectangle rectangle = new Rectangle(x, y, extent.x, extent.y);
        if (box > 0) {
            rectangle.x -= box;
            rectangle.y -= box;
            rectangle.width += 2 * box;
            rectangle.height += 2 * box;
            gc.fillRectangle(rectangle);
        }
        gc.drawText(text, x, y, true);
        return rectangle;
    }

    public static Rectangle drawTextNotCenter(GC gc, int cX, int cY, String text, int box) {
        Point extent = gc.stringExtent(text);
        int x = cX - extent.x / 2;
        if (x < box) {
            x = box;
        }
        Rectangle rectangle = new Rectangle(cX, cY, extent.x, extent.y);
        if (box > 0) {
            rectangle.x -= box;
            rectangle.y -= box;
            rectangle.width += 2 * box;
            rectangle.height += 2 * box;
            gc.fillRectangle(rectangle);
        }
        gc.drawText(text, cX, cY, true);
        return rectangle;
    }

    public AbstractCanvas(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractCanvas.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                AbstractCanvas.this.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractCanvas.this.dispose();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                AbstractCanvas.this.onMouseMove(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                AbstractCanvas.this.onMouseMove(e.x, e.y);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    AbstractCanvas.this.onMouseDown(e.x, e.y);
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image buffer = new Image((Device)AbstractCanvas.this.getDisplay(), AbstractCanvas.this.getBounds());
                GC canvasGc = e.gc;
                GC bufferGC = new GC((Drawable)buffer);
                bufferGC.setAdvanced(true);
                bufferGC.setBackground(canvasGc.getBackground());
                bufferGC.fillRectangle(buffer.getBounds());
                AbstractCanvas.this.paint(bufferGC);
                canvasGc.drawImage(buffer, 0, 0);
                bufferGC.dispose();
                buffer.dispose();
                AbstractCanvas.this.scheduleRun();
            }
        });
    }

    protected final Color createColor(int r, int g, int b) {
        Display display = this.getDisplay();
        Color color = new Color((Device)display, r, g, b);
        this.resources.add((Resource)color);
        return color;
    }

    protected final Font createFont(int pixelHeight) {
        return this.createFont(pixelHeight, 0, new String[0]);
    }

    protected final Font createFont(int pixelHeight, int pixelWidth, String ... testStrings) {
        if (testStrings.length == 0) {
            pixelWidth = Integer.MAX_VALUE;
            testStrings = new String[]{"Ag"};
        }
        Display display = this.getDisplay();
        GC fontGC = new GC((Drawable)display);
        try {
            FontData[] fontData = this.baseFont.getFontData();
            int fontSize = 40;
            while (fontSize > 0) {
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setHeight(fontSize);
                    fontData[i].setStyle(1);
                    ++i;
                }
                Font font = new Font((Device)display, fontData);
                fontGC.setFont(font);
                if (this.isFontSmallEnough(pixelHeight, pixelWidth, fontGC, testStrings)) {
                    this.resources.add((Resource)font);
                    Font font2 = font;
                    return font2;
                }
                font.dispose();
                --fontSize;
            }
            throw new RuntimeException("Could not create font: " + pixelHeight);
        }
        finally {
            fontGC.dispose();
        }
    }

    public void dispose() {
        for (Resource resource : this.resources) {
            if (resource == null || resource.isDisposed()) continue;
            resource.dispose();
        }
    }

    protected synchronized void doRun() {
        if (this.isDisposed()) {
            return;
        }
        this.currentTime += 20L;
        boolean needsRedraw = this.needRedraw();
        if (needsRedraw) {
            this.redraw();
        } else {
            this.scheduleRun();
        }
    }

    public Rectangle drawImage(GC gc, Image image, int cX, int cY) {
        Rectangle bounds = image.getBounds();
        gc.drawImage(image, cX -= bounds.width / 2, cY -= bounds.height / 2);
        return new Rectangle(cX, cY, bounds.width, bounds.height);
    }

    protected final Font getBaseFont() {
        return this.baseFont;
    }

    protected void init() {
        Display display = this.getDisplay();
        Font initialFont = this.getFont();
        FontData[] fontData = initialFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(16);
            fontData[i].setStyle(1);
            ++i;
        }
        this.baseFont = new Font((Device)display, fontData);
    }

    private boolean isFontSmallEnough(int pixelHeight, int pixelWidth, GC fontGC, String[] testStrings) {
        String[] stringArray = testStrings;
        int n = testStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String testString = stringArray[n2];
            Point extent = fontGC.stringExtent(testString);
            if (extent.y > pixelHeight || extent.x > pixelWidth) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected final Image loadImage(String name) {
        URL url = null;
        try {
            url = ProjectUI.getDefault().getBundle().getEntry("images/" + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageDescriptor imagedesc = ImageDescriptor.createFromURL(url);
        Image image = imagedesc.createImage();
        this.resources.add((Resource)image);
        return image;
    }

    protected abstract boolean needRedraw();

    protected abstract void onMouseDown(int var1, int var2);

    protected abstract void onMouseMove(int var1, int var2);

    protected abstract void paint(GC var1);

    protected void scheduleRun() {
        this.getDisplay().timerExec(10, this.runnable);
    }
}

