/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ConvertedProjectLocationValidationService
extends ValidationService {
    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)this.op().getConvertedProjectLocation().content(true);
        if (currentProjectLocation != null) {
            String currentPath = currentProjectLocation.toPortableString();
            if (!Path.EMPTY.isValidPath(currentPath)) {
                retval = Status.createErrorStatus((String)("\"" + currentPath + "\" is not a valid path."));
            } else {
                IPath osPath = Path.fromOSString((String)currentPath);
                if (!osPath.toFile().isAbsolute()) {
                    retval = Status.createErrorStatus((String)("\"" + currentPath + "\" is not an absolute path."));
                } else if (!osPath.toFile().exists() && !this.canCreate(osPath.toFile())) {
                    retval = Status.createErrorStatus((String)("Cannot create project content at \"" + currentPath + "\""));
                }
            }
        } else {
            retval = Status.createErrorStatus((String)"Converted Project Location must be specified.");
        }
        return retval;
    }

    private LiferayUpgradeDataModel op() {
        return (LiferayUpgradeDataModel)this.context(LiferayUpgradeDataModel.class);
    }
}

