/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.project.ui.upgrade.animated.AbstractCanvas;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageAction;
import com.liferay.ide.project.ui.upgrade.animated.PageActionEvent;
import com.liferay.ide.project.ui.upgrade.animated.PageNavigateEvent;
import com.liferay.ide.project.ui.upgrade.animated.SelectionChangedListener;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class NavigatorControl
extends AbstractCanvas
implements SelectionChangedListener {
    public static final int BORDER = 30;
    private static final int BACK = -2;
    private static final int NEXT = -3;
    private static final int CHOICES = -4;
    private int hover = -1;
    private int oldHover = -1;
    private final Image[] backImages = new Image[2];
    private final Image[] nextImages = new Image[2];
    private int buttonR;
    private int answerY;
    private Rectangle backBox;
    private Rectangle nextBox;
    private int pageY;
    private Rectangle[] actionBoxes;
    private Display display;
    private int select = 0;
    private boolean needRedraw = false;
    private final List<UpgradeView.PageNavigatorListener> naviListeners = Collections.synchronizedList(new ArrayList());
    private final List<UpgradeView.PageActionListener> actionListeners = Collections.synchronizedList(new ArrayList());

    public NavigatorControl(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.display = this.getDisplay();
        this.setBackground(this.display.getSystemColor(1));
        this.init();
        this.scheduleRun();
    }

    protected boolean actionOnMouseDown(int x, int y) {
        int i = this.getAction(x, y);
        if (i != -1) {
            this.doAction(i);
            return true;
        }
        return false;
    }

    protected int actionOnMouseMove(int x, int y) {
        int i = this.getAction(x, y);
        if (i != -1) {
            return -4 - i;
        }
        return -1;
    }

    public void addPageActionListener(UpgradeView.PageActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addPageNavigateListener(UpgradeView.PageNavigatorListener listener) {
        this.naviListeners.add(listener);
    }

    private void doAction(int i) {
        Page page = this.getSelectedPage();
        PageAction oldSelection = page.getSelectedAction();
        PageAction[] pageActions = page.getActions();
        PageAction targetAction = pageActions[i];
        if (targetAction.equals(oldSelection)) {
            targetAction = null;
        }
        page.setSelectedAction(targetAction);
        PageActionEvent event = new PageActionEvent();
        event.setTargetPageIndex(-1);
        if (page.showNextPage() && targetAction != null) {
            event.setTargetPageIndex(this.select + 1);
        }
        for (UpgradeView.PageActionListener listener : this.actionListeners) {
            listener.onPageAction(event);
        }
        this.needRedraw = true;
    }

    public final int getAction(int x, int y) {
        PageAction[] actions = this.getSelectedPage().getActions();
        if (actions == null || actions.length < 1) {
            return -1;
        }
        int i = 0;
        while (i < actions.length) {
            Rectangle box = this.actionBoxes[i];
            if (box != null && box.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Page getSelectedPage() {
        return UpgradeView.getPage(this.select);
    }

    @Override
    protected void init() {
        super.init();
        this.backImages[0] = this.loadImage("back.png");
        this.backImages[1] = this.loadImage("back_hover.png");
        this.nextImages[0] = this.loadImage("next.png");
        this.nextImages[1] = this.loadImage("next_hover.png");
        this.buttonR = this.nextImages[0].getBounds().height / 2;
        this.answerY = 5 + this.buttonR;
        this.actionBoxes = new Rectangle[2];
    }

    @Override
    protected boolean needRedraw() {
        boolean retVal = false;
        if (this.needRedraw) {
            this.needRedraw = false;
            retVal = true;
        }
        if (this.hover != this.oldHover) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    protected void onMouseDown(int x, int y) {
        Page page;
        boolean isNavigate = false;
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE && (page = this.getSelectedPage()) != null) {
            PageNavigateEvent event = new PageNavigateEvent();
            if (page.showBackPage() && this.backBox != null && this.backBox.contains(x, y)) {
                event.setTargetPage(this.select - 1);
                isNavigate = true;
            }
            if (page.showNextPage() && this.nextBox != null && this.nextBox.contains(x, y)) {
                event.setTargetPage(this.select + 1);
                isNavigate = true;
            }
            if (isNavigate) {
                for (UpgradeView.PageNavigatorListener listener : this.naviListeners) {
                    listener.onPageNavigate(event);
                }
            }
            this.actionOnMouseDown(x, y);
        }
    }

    @Override
    protected void onMouseMove(int x, int y) {
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
            Page page = this.getSelectedPage();
            if (page != null) {
                if (page.showBackPage() && this.backBox != null && this.backBox.contains(x, y)) {
                    this.hover = -2;
                    return;
                }
                if (page.showNextPage() && this.nextBox != null && this.nextBox.contains(x, y)) {
                    this.hover = -3;
                    return;
                }
                this.hover = this.actionOnMouseMove(x, y);
                return;
            }
        } else {
            this.hover = -1;
        }
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
        this.select = targetSelection;
        this.needRedraw = true;
    }

    @Override
    protected void paint(GC gc) {
        gc.setFont(this.getBaseFont());
        gc.setLineWidth(3);
        gc.setAntialias(1);
        Page page = this.getSelectedPage();
        this.backBox = null;
        this.nextBox = null;
        if (page.showBackPage()) {
            this.backBox = this.drawImage(gc, this.backImages[this.hover == -2 ? 1 : 0], this.getBounds().width / 2 - 200, this.answerY);
        }
        if (page.showNextPage()) {
            this.nextBox = this.drawImage(gc, this.nextImages[this.hover == -3 ? 1 : 0], this.getBounds().width / 2 + 200, this.answerY);
        }
        this.paintActions(gc, page);
        this.oldHover = this.hover;
    }

    public Rectangle paintAction(GC gc, int index, int x, int y, boolean hovered, boolean selected, PageAction action) {
        Image[] images = action.getImages();
        Image image = images[0];
        if (hovered) {
            image = images[2];
        } else if (selected) {
            image = images[1];
        }
        return this.drawImage(gc, image, x, y);
    }

    private void paintActions(GC gc, Page page) {
        PageAction[] actions = page.getActions();
        PageAction selectedAction = page.getSelectedAction();
        if (actions == null) {
            return;
        }
        boolean[] selecteds = new boolean[actions.length];
        boolean[] hovereds = new boolean[actions.length];
        Point[] sizes = new Point[actions.length];
        int height = 0;
        int i = 0;
        while (i < actions.length) {
            selecteds[i] = actions[i].equals(selectedAction);
            if (-4 - i == this.hover) {
                hovereds[i] = true;
            }
            sizes[i] = actions[i].getSize();
            height = Math.max(height, sizes[i].y);
            ++i;
        }
        int x = this.getBounds().width / 2 - 40;
        int y = this.answerY - this.pageY;
        int i2 = 0;
        while (i2 < actions.length) {
            PageAction action = actions[i2];
            this.actionBoxes[i2] = this.paintAction(gc, i2, x, y, hovereds[i2], selecteds[i2], action);
            x = this.getBounds().width / 2 + 40;
            ++i2;
        }
    }
}

