/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.ui.ImageResource;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchResult;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchResultPage;
import org.eclipse.wst.xml.search.ui.participant.IMatchPresentation;
import org.eclipse.wst.xml.search.ui.util.DOMUtils;
import org.w3c.dom.Node;

public class XMLLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final XMLSearchResultPage fPage;
    private final WorkbenchLabelProvider fLabelProvider;
    private final Image fAttributeMatchImage;
    private final Image fElementMatchImage;
    private final Image fTextMatchImage;
    private final Map<IMatchPresentation, ILabelProvider> fLabelProviderMap;
    private final ListenerList fListeners;

    public XMLLabelProvider(XMLSearchResultPage page) {
        this.fPage = page;
        this.fLabelProvider = new WorkbenchLabelProvider();
        this.fAttributeMatchImage = ImageResource.getImage("attribute_obj");
        this.fTextMatchImage = ImageResource.getImage("text_obj");
        this.fElementMatchImage = ImageResource.getImage("element_obj");
        this.fLabelProviderMap = new HashMap<IMatchPresentation, ILabelProvider>(5);
        this.fListeners = new ListenerList();
    }

    public String getText(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getName();
        }
        if (element instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            return DOMUtils.toString(node);
        }
        return this.getParticipantText(element);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return new StyledString(resource.getName());
        }
        if (element instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            return new StyledString(DOMUtils.toString(node));
        }
        return this.getStyledParticipantText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            switch (node.getNodeType()) {
                case 2: {
                    return this.fAttributeMatchImage;
                }
                case 3: {
                    return this.fTextMatchImage;
                }
                case 1: {
                    return this.fElementMatchImage;
                }
            }
        }
        if (!(element instanceof IResource)) {
            return this.getParticipantImage(element);
        }
        IResource resource = (IResource)element;
        Image image = this.fLabelProvider.getImage((Object)resource);
        return image;
    }

    protected String getParticipantText(Object element) {
        ILabelProvider labelProvider = this.getLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        return "";
    }

    protected StyledString getStyledParticipantText(Object element) {
        ILabelProvider labelProvider = this.getLabelProvider(element);
        if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider).getStyledText(element);
        }
        if (labelProvider != null) {
            return new StyledString(labelProvider.getText(element));
        }
        return new StyledString();
    }

    protected Image getParticipantImage(Object element) {
        ILabelProvider lp = this.getLabelProvider(element);
        if (lp == null) {
            return null;
        }
        return lp.getImage(element);
    }

    private ILabelProvider getLabelProvider(Object element) {
        AbstractTextSearchResult input = this.fPage.getInput();
        if (!(input instanceof XMLSearchResult)) {
            return null;
        }
        IMatchPresentation participant = ((XMLSearchResult)input).getSearchParticpant(element);
        if (participant == null) {
            return null;
        }
        ILabelProvider lp = this.fLabelProviderMap.get(participant);
        if (lp == null) {
            lp = participant.createLabelProvider();
            this.fLabelProviderMap.put(participant, lp);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                lp.addListener((ILabelProviderListener)listeners[i]);
                ++i;
            }
        }
        return lp;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.addListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.getLabelProvider(element).isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.removeListener(listener);
        }
    }
}

