/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor.internal;

import com.liferay.ide.portlet.core.model.PortletApp;
import com.liferay.ide.portlet.core.util.PortletUtil;
import com.liferay.ide.portlet.ui.editor.internal.AbstractResourceBundleActionHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;

public class CreatePortletAppResourceBundleActionHandler
extends AbstractResourceBundleActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        Element element = this.getModelElement();
        Property property = this.property();
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                CreatePortletAppResourceBundleActionHandler.this.refreshEnablementState();
            }
        };
        element.attach(this.listener, property.definition().name());
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    CreatePortletAppResourceBundleActionHandler.this.getModelElement().detach(CreatePortletAppResourceBundleActionHandler.this.listener, CreatePortletAppResourceBundleActionHandler.this.property().definition().name());
                }
            }
        });
    }

    protected Object run(Presentation context) {
        Element element = this.getModelElement();
        IProject project = (IProject)element.adapt(IProject.class);
        Property property = this.property();
        Value resourceBundle = element.property((ValueProperty)property.definition());
        String resourceBundleText = resourceBundle.text();
        int index = resourceBundleText.lastIndexOf(".");
        if (index == -1) {
            index = resourceBundleText.length();
        }
        String packageName = resourceBundleText.substring(0, index);
        String defaultRBFileName = PortletUtil.convertJavaToIoFileName((String)resourceBundleText, (String)"properties", (String[])new String[0]);
        IFolder rbSourecFolder = this.getResourceBundleFolderLocation(project, defaultRBFileName);
        IPath entryPath = rbSourecFolder.getLocation();
        if (this.getModelElement() instanceof PortletApp) {
            ArrayList<IFile> missingRBFiles = new ArrayList<IFile>();
            StringBuilder rbFileBuffer = new StringBuilder("#Portlet Application Resource Bundle \n");
            IFile rbFile = this.wroot.getFileForLocation(entryPath.append(defaultRBFileName));
            missingRBFiles.add(rbFile);
            this.createFiles(context, project, packageName, missingRBFiles, rbFileBuffer);
            this.setEnabled(false);
            this.getModelElement().property(this.property().definition()).refresh();
        }
        return null;
    }
}

